/*
 * Copyright (C) 2013 Alcatel-Lucent.
 *
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 * Licensed to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package molecule.parsers.utils

class ReverseAccumulator[Elem] private (racc: List[Elem], len: Int) {

  def length: Int = len

  def prepend(elem: Elem, elemLength: Int) = new ReverseAccumulator(elem :: racc, elemLength + len)

  def result[To](f: Int => MPrependBuilder[Elem, To]): To =
    racc.foldLeft(f(len))(_ prepend _).result
}

object ReverseAccumulator {

  def apply[Elem](): ReverseAccumulator[Elem] = new ReverseAccumulator[Elem](Nil, 0)

}