/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.api;

import cucumber.perf.salad.ast.Slice;
import cucumber.runtime.model.CucumberFeature;
import gherkin.SymbolCounter;
import gherkin.ast.Background;
import gherkin.ast.DataTable;
import gherkin.ast.DocString;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.GherkinDocument;
import gherkin.ast.Location;
import gherkin.ast.Node;
import gherkin.ast.Scenario;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import gherkin.ast.Tag;
import gherkin.events.PickleEvent;
import gherkin.pickles.Argument;
import gherkin.pickles.Pickle;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleLocation;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleStep;
import gherkin.pickles.PickleString;
import gherkin.pickles.PickleTable;
import gherkin.pickles.PickleTag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PerfCompiler {
    public List<PickleEvent> compileFeature(CucumberFeature feature, Slice slice) {
        ArrayList<PickleEvent> pickleEvents = new ArrayList<PickleEvent>();
        for (Pickle pickle : this.compile(feature.getGherkinFeature(), slice)) {
            pickleEvents.add(new PickleEvent(feature.getUri().toString(), pickle));
        }
        return pickleEvents;
    }

    public List<Pickle> compile(GherkinDocument gherkinDocument, Slice slice) {
        ArrayList<Pickle> pickles = new ArrayList<Pickle>();
        Feature feature = gherkinDocument.getFeature();
        if (feature == null) {
            return pickles;
        }
        String language = feature.getLanguage();
        List featureTags = feature.getTags();
        ArrayList<PickleStep> backgroundSteps = new ArrayList();
        for (ScenarioDefinition scenarioDefinition : feature.getChildren()) {
            if (scenarioDefinition instanceof Background) {
                backgroundSteps = this.pickleSteps(scenarioDefinition, slice);
                continue;
            }
            if (scenarioDefinition instanceof Scenario) {
                this.compileScenario(pickles, backgroundSteps, (Scenario)scenarioDefinition, featureTags, language, slice);
                continue;
            }
            this.compileScenarioOutline(pickles, backgroundSteps, (ScenarioOutline)scenarioDefinition, featureTags, language, slice);
        }
        return pickles;
    }

    private void compileScenario(List<Pickle> pickles, List<PickleStep> backgroundSteps, Scenario scenario, List<Tag> featureTags, String language, Slice slice) {
        ArrayList<PickleStep> steps = new ArrayList<PickleStep>();
        if (!scenario.getSteps().isEmpty()) {
            steps.addAll(backgroundSteps);
        }
        ArrayList<Tag> scenarioTags = new ArrayList<Tag>();
        scenarioTags.addAll(featureTags);
        scenarioTags.addAll(scenario.getTags());
        steps.addAll(this.pickleSteps((ScenarioDefinition)scenario, slice));
        Pickle pickle = new Pickle(scenario.getName(), language, steps, this.pickleTags(scenarioTags), Collections.singletonList(this.pickleLocation(scenario.getLocation())));
        pickles.add(pickle);
    }

    private void compileScenarioOutline(List<Pickle> pickles, List<PickleStep> backgroundSteps, ScenarioOutline scenarioOutline, List<Tag> featureTags, String language, Slice slice) {
        for (Examples examples : scenarioOutline.getExamples()) {
            if (examples.getTableHeader() == null) continue;
            List variableCells = examples.getTableHeader().getCells();
            for (TableRow values : examples.getTableBody()) {
                List valueCells = values.getCells();
                ArrayList<PickleStep> steps = new ArrayList<PickleStep>();
                if (!scenarioOutline.getSteps().isEmpty()) {
                    steps.addAll(backgroundSteps);
                }
                ArrayList<Tag> tags = new ArrayList<Tag>();
                tags.addAll(featureTags);
                tags.addAll(scenarioOutline.getTags());
                tags.addAll(examples.getTags());
                for (Step scenarioOutlineStep : scenarioOutline.getSteps()) {
                    String stepText = this.interpolate(scenarioOutlineStep.getText(), variableCells, valueCells);
                    PickleStep pickleStep = new PickleStep(stepText, this.createPickleArguments(scenarioOutlineStep.getArgument(), variableCells, valueCells), Arrays.asList(this.pickleLocation(values.getLocation()), this.pickleStepLocation(scenarioOutlineStep)));
                    steps.add(pickleStep);
                }
                Pickle pickle = new Pickle(this.interpolate(scenarioOutline.getName(), variableCells, valueCells), language, steps, this.pickleTags(tags), Arrays.asList(this.pickleLocation(values.getLocation()), this.pickleLocation(scenarioOutline.getLocation())));
                pickles.add(pickle);
            }
        }
    }

    private List<Argument> createPickleArguments(Node argument) {
        List<TableCell> noCells = Collections.emptyList();
        return this.createPickleArguments(argument, noCells, noCells);
    }

    private List<Argument> createPickleArguments(Node argument, List<TableCell> variableCells, List<TableCell> valueCells) {
        ArrayList<Argument> result = new ArrayList<Argument>();
        if (argument == null) {
            return result;
        }
        if (argument instanceof DataTable) {
            DataTable t = (DataTable)argument;
            List rows = t.getRows();
            ArrayList<PickleRow> newRows = new ArrayList<PickleRow>(rows.size());
            for (TableRow row : rows) {
                List cells = row.getCells();
                ArrayList<PickleCell> newCells = new ArrayList<PickleCell>();
                for (TableCell cell : cells) {
                    newCells.add(new PickleCell(this.pickleLocation(cell.getLocation()), this.interpolate(cell.getValue(), variableCells, valueCells)));
                }
                newRows.add(new PickleRow(newCells));
            }
            result.add((Argument)new PickleTable(newRows));
        } else if (argument instanceof DocString) {
            DocString ds = (DocString)argument;
            result.add((Argument)new PickleString(this.pickleLocation(ds.getLocation()), this.interpolate(ds.getContent(), variableCells, valueCells)));
        } else {
            throw new RuntimeException("Unexpected argument type: " + argument);
        }
        return result;
    }

    private List<PickleStep> pickleSteps(ScenarioDefinition scenarioDefinition, Slice slice) {
        ArrayList<PickleStep> result = new ArrayList<PickleStep>();
        for (Step step : scenarioDefinition.getSteps()) {
            result.add(this.pickleStep(step, slice));
        }
        return Collections.unmodifiableList(result);
    }

    private PickleStep pickleStep(Step step, Slice slice) {
        String text = step.getText();
        text = slice != null ? slice.replaceParameter(text) : text;
        return new PickleStep(text, this.createPickleArguments(step.getArgument()), Collections.singletonList(this.pickleStepLocation(step)));
    }

    private String interpolate(String name, List<TableCell> variableCells, List<TableCell> valueCells) {
        int col = 0;
        for (TableCell variableCell : variableCells) {
            TableCell valueCell = valueCells.get(col++);
            String header = variableCell.getValue();
            String value = valueCell.getValue();
            name = name.replace("<" + header + ">", value);
        }
        return name;
    }

    private PickleLocation pickleStepLocation(Step step) {
        return new PickleLocation(step.getLocation().getLine(), step.getLocation().getColumn() + (step.getKeyword() != null ? SymbolCounter.countSymbols((String)step.getKeyword()) : 0));
    }

    private PickleLocation pickleLocation(Location location) {
        return new PickleLocation(location.getLine(), location.getColumn());
    }

    private List<PickleTag> pickleTags(List<Tag> tags) {
        ArrayList<PickleTag> result = new ArrayList<PickleTag>();
        for (Tag tag : tags) {
            result.add(this.pickleTag(tag));
        }
        return result;
    }

    private PickleTag pickleTag(Tag tag) {
        return new PickleTag(this.pickleLocation(tag.getLocation()), tag.getName());
    }
}

