/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.api;

import cucumber.perf.salad.ast.Count;
import cucumber.perf.salad.ast.Group;
import cucumber.perf.salad.ast.Runners;
import cucumber.perf.salad.ast.Slice;
import cucumber.runtime.model.CucumberFeature;
import gherkin.ast.DataTable;
import gherkin.ast.Node;
import gherkin.ast.TableRow;
import java.util.ArrayList;
import java.util.List;

public class PerfGroup {
    private final String keyword;
    private final String text;
    private int threads;
    private int maxThreads;
    private int count;
    private int running = 0;
    private int ran = 0;
    private DataTable slices;
    private List<CucumberFeature> features;

    public PerfGroup(String keyword, String text, int threads, int count, DataTable slices) {
        this.keyword = keyword;
        this.text = text;
        this.threads = threads;
        this.count = count;
        this.maxThreads = threads;
        this.slices = slices;
    }

    public PerfGroup(Group group) {
        this.keyword = group.getKeyword();
        this.text = group.getText();
        for (Node a : group.getArguments()) {
            if (a instanceof DataTable) {
                this.slices = (DataTable)a;
                continue;
            }
            if (a instanceof Count) {
                this.count = Integer.parseInt(((Count)a).getContent());
                continue;
            }
            if (!(a instanceof Runners)) continue;
            this.maxThreads = this.threads = Integer.parseInt(((Runners)a).getContent());
        }
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public int getRunning() {
        return this.running;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String getText() {
        return this.text;
    }

    public void incrementRunning() {
        ++this.running;
    }

    public void decrementRunning() {
        --this.running;
    }

    public int getRan() {
        return this.ran;
    }

    public void incrementRan() {
        ++this.ran;
    }

    public int getThreads() {
        return this.threads;
    }

    public int getCount() {
        return this.count;
    }

    public DataTable getSlices() {
        return this.slices;
    }

    public Slice getSlice() {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        if (this.slices != null && this.slices.getRows().size() > 1) {
            rows.add((TableRow)this.slices.getRows().get(0));
            int sel = this.ran % this.slices.getRows().size();
            if (sel < this.slices.getRows().size() - 1) {
                ++sel;
            }
            rows.add((TableRow)this.slices.getRows().get(sel));
            ++this.ran;
            return new Slice(rows);
        }
        ++this.ran;
        return null;
    }

    public List<CucumberFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<CucumberFeature> features) {
        this.features = features;
    }
}

