/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.api;

import cucumber.api.event.Event;
import cucumber.api.event.TestSourceRead;
import cucumber.perf.api.PlanBuilder;
import cucumber.perf.api.URIPath;
import cucumber.perf.salad.ast.SaladDocument;
import cucumber.runner.EventBus;
import cucumber.runtime.CucumberException;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceLoader;
import cucumber.util.Encoding;
import io.cucumber.core.model.FeatureWithLines;
import io.cucumber.core.model.RerunLoader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

public class PerfPlan
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String uri;
    private SaladDocument saladDocument;
    private String saladSource;
    public static final Pattern RERUN_PATH_SPECIFICATION = Pattern.compile("(?m:^| |)(.*?\\.feature(?:(?::\\d+)*))");

    public static List<PerfPlan> load(ResourceLoader resourceLoader, List<String> planPaths, PrintStream out) {
        List<PerfPlan> perfPlans = PerfPlan.load(resourceLoader, planPaths);
        if (perfPlans.isEmpty()) {
            if (planPaths.isEmpty()) {
                out.println("Got no path to plan directory or plan file");
            } else {
                out.println(String.format("No plans found at %s", planPaths));
            }
        }
        return perfPlans;
    }

    public static List<PerfPlan> load(ResourceLoader resourceLoader, List<String> planPaths) {
        ArrayList<PerfPlan> perfPlan = new ArrayList<PerfPlan>();
        PlanBuilder builder = new PlanBuilder(perfPlan);
        for (String planPath : planPaths) {
            if (planPath.startsWith("@")) {
                PerfPlan.loadFromRerunFile(builder, resourceLoader, planPath.substring(1));
                continue;
            }
            PerfPlan.loadFromFeaturePath(builder, resourceLoader, URIPath.parse(planPath), false);
        }
        Collections.sort(perfPlan, new PerfPlanUriComparator());
        return perfPlan;
    }

    private static void loadFromRerunFile(PlanBuilder builder, ResourceLoader resourceLoader, String rerunPath) {
        for (FeatureWithLines pathWithLines : new RerunLoader(resourceLoader).load(URIPath.parse(rerunPath))) {
            PerfPlan.loadFromFileSystemOrClasspath(builder, resourceLoader, pathWithLines.uri());
        }
    }

    private static String read(Resource resource) {
        try {
            return Encoding.readFile((Resource)resource);
        }
        catch (IOException e) {
            throw new CucumberException("Failed to read resource:" + resource.getPath(), (Throwable)e);
        }
    }

    private static void loadFromFileSystemOrClasspath(PlanBuilder builder, ResourceLoader resourceLoader, URI featurePath) {
        try {
            PerfPlan.loadFromFeaturePath(builder, resourceLoader, featurePath, false);
        }
        catch (IllegalArgumentException originalException) {
            if (!featurePath.getScheme().startsWith("classpath") && originalException.getMessage().contains("Not a file or directory")) {
                try {
                    PerfPlan.loadFromFeaturePath(builder, resourceLoader, URIPath.parse("classpath" + featurePath.toString()), true);
                }
                catch (IllegalArgumentException secondException) {
                    if (secondException.getMessage().contains("No resource found for")) {
                        throw new IllegalArgumentException("Neither found on file system or on classpath: " + originalException.getMessage() + ", " + secondException.getMessage());
                    }
                    throw secondException;
                }
            }
            throw originalException;
        }
    }

    private static void loadFromFeaturePath(PlanBuilder builder, ResourceLoader resourceLoader, URI planPath, boolean failOnNoResource) {
        Iterable resources = resourceLoader.resources(planPath, ".plan");
        if (failOnNoResource && !resources.iterator().hasNext()) {
            throw new IllegalArgumentException("No resource found for: " + planPath);
        }
        for (Resource resource : resources) {
            builder.parse(resource);
        }
    }

    public PerfPlan(SaladDocument saladDocument, String uri, String saladSource) {
        this.saladDocument = saladDocument;
        this.uri = uri;
        this.saladSource = saladSource;
    }

    public SaladDocument getSaladPlan() {
        return this.saladDocument;
    }

    public String getUri() {
        return this.uri;
    }

    public void sendTestSourceRead(EventBus bus) {
        bus.send((Event)new TestSourceRead(bus.getTime(), bus.getTimeMillis().longValue(), this.uri, this.saladSource));
    }

    private static class PerfPlanUriComparator
    implements Comparator<PerfPlan> {
        private PerfPlanUriComparator() {
        }

        @Override
        public int compare(PerfPlan a, PerfPlan b) {
            return a.getUri().compareTo(b.getUri());
        }
    }
}

