/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.api;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class URIPath {
    private URIPath() {
    }

    public static URI parse(String pathIdentifier) {
        if (URIPath.nonStandardPathSeparatorInUse(pathIdentifier)) {
            String standardized = URIPath.replaceNonStandardPathSeparator(pathIdentifier);
            return URIPath.parseAssumeFileScheme(standardized);
        }
        if (URIPath.probablyURI(pathIdentifier)) {
            return URIPath.parseProbableURI(pathIdentifier);
        }
        return URIPath.parseAssumeFileScheme(pathIdentifier);
    }

    private static URI parseProbableURI(String pathIdentifier) {
        return URI.create(pathIdentifier);
    }

    private static boolean probablyURI(String pathIdentifier) {
        return pathIdentifier.matches("^\\w+:.*$");
    }

    private static String replaceNonStandardPathSeparator(String pathIdentifier) {
        return pathIdentifier.replace(File.separatorChar, '/');
    }

    private static boolean nonStandardPathSeparatorInUse(String pathIdentifier) {
        return File.separatorChar != '/' && pathIdentifier.contains(File.separator);
    }

    private static URI parseAssumeFileScheme(String pathIdentifier) {
        File pathFile = new File(pathIdentifier);
        if (pathFile.isAbsolute()) {
            return pathFile.toURI();
        }
        try {
            URI root = new File("").toURI();
            URI relative = root.relativize(pathFile.toURI());
            return new URI("file", relative.getSchemeSpecificPart(), relative.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

