/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.api.event;

import cucumber.perf.api.event.ConfigStatistics;
import cucumber.perf.api.event.Event;
import cucumber.perf.api.event.GroupEvent;
import cucumber.perf.api.event.PerfRunFinished;
import cucumber.perf.api.event.PerfRunStarted;
import cucumber.perf.api.event.SimulationFinished;
import cucumber.perf.api.event.SimulationStarted;
import cucumber.perf.api.event.StatisticsFinished;
import cucumber.perf.api.event.StatisticsStarted;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

final class CanonicalEventOrder
implements Comparator<Event> {
    private static final FixedEventOrderComparator fixedOrder = new FixedEventOrderComparator();

    CanonicalEventOrder() {
    }

    @Override
    public int compare(Event a, Event b) {
        int fixedOrder = CanonicalEventOrder.fixedOrder.compare(a, b);
        return fixedOrder;
    }

    private static final class FixedEventOrderComparator
    implements Comparator<Event> {
        private final List<Class<? extends Event>> fixedOrder = Arrays.asList(PerfRunStarted.class, ConfigStatistics.class, SimulationStarted.class, GroupEvent.class, SimulationFinished.class, StatisticsStarted.class, StatisticsFinished.class, PerfRunFinished.class);

        private FixedEventOrderComparator() {
        }

        @Override
        public int compare(Event a, Event b) {
            return Integer.compare(this.requireInFixOrder(a.getClass()), this.requireInFixOrder(b.getClass()));
        }

        private int requireInFixOrder(Class<? extends Event> o) {
            int index = this.findInFixedOrder(o);
            if (index < 0) {
                throw new IllegalStateException(o + "was not in " + this.fixedOrder);
            }
            return index;
        }

        private int findInFixedOrder(Class<? extends Event> o) {
            for (int i = 0; i < this.fixedOrder.size(); ++i) {
                if (!this.fixedOrder.get(i).isAssignableFrom(o)) continue;
                return i;
            }
            return -1;
        }
    }
}

