/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.api.result;

import cucumber.api.Result;
import java.time.Duration;
import java.time.LocalDateTime;

public class BaseResult {
    private LocalDateTime start = LocalDateTime.now();
    private LocalDateTime stop = LocalDateTime.now();
    private String name;
    private Result result;

    public BaseResult() {
    }

    public BaseResult(String name, Result result, LocalDateTime start, LocalDateTime stop) {
        this.name = name;
        this.result = result;
        this.start = start;
        this.stop = stop;
    }

    public BaseResult(BaseResult result) {
        this.name = result.getName();
        this.result = new Result(result.getResult().getStatus(), result.getResultDuration(), result.getError());
        this.start = result.getStart();
        this.stop = result.getStop();
    }

    public LocalDateTime getStart() {
        return this.start;
    }

    public void setStart(LocalDateTime start) {
        this.start = start;
    }

    public LocalDateTime getStop() {
        return this.stop;
    }

    public void setStop(LocalDateTime stop) {
        this.stop = stop;
    }

    public Duration getDuration() {
        return Duration.between(this.start, this.stop);
    }

    public Long getResultDuration() {
        return this.result.getDuration();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public boolean isPassed() {
        return this.result.getError() == null;
    }

    public Throwable getError() {
        return this.result.getError();
    }
}

