/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.api.result;

import cucumber.api.Result;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestRunStarted;
import cucumber.perf.api.result.GroupResult;
import java.time.Duration;
import java.time.LocalDateTime;

public class GroupResultListener
implements EventListener {
    private String groupName = "";
    private GroupResult result = null;
    private LocalDateTime start = LocalDateTime.now();
    private final EventHandler<TestRunStarted> testRunStartedHandler = new EventHandler<TestRunStarted>(){

        public void receive(TestRunStarted event) {
            GroupResultListener.this.start = LocalDateTime.now();
        }
    };
    private final EventHandler<TestRunFinished> testRunFinishedHandler = new EventHandler<TestRunFinished>(){

        public void receive(TestRunFinished event) {
            GroupResultListener.this.result = new GroupResult(GroupResultListener.this.groupName, new Result(Result.Type.PASSED, Long.valueOf(Duration.between(GroupResultListener.this.start, LocalDateTime.now()).toNanos()), null), GroupResultListener.this.start, LocalDateTime.now());
        }
    };

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestRunStarted.class, this.testRunStartedHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.testRunFinishedHandler);
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public GroupResult getResult() {
        return this.result;
    }
}

