/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.api.result;

import cucumber.api.Result;
import cucumber.perf.api.result.BaseResult;
import cucumber.perf.api.result.GroupResult;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SimulationResult
extends BaseResult {
    private List<GroupResult> childResults = new ArrayList<GroupResult>();
    private long totalRan = 0L;

    public SimulationResult() {
    }

    public SimulationResult(String name, Result result, LocalDateTime start, LocalDateTime stop, List<GroupResult> childResults) {
        super(name, result, start, stop);
        this.childResults = childResults;
        for (GroupResult gr : childResults) {
            this.totalRan += (long)gr.getChildResults().size();
        }
    }

    public SimulationResult(SimulationResult result) {
        super(result.getName(), new Result(result.getResult().getStatus(), result.getResultDuration(), result.getResult().getError()), LocalDateTime.from(result.getStart()), LocalDateTime.from(result.getStop()));
        for (GroupResult gr : result.getChildResults()) {
            this.totalRan += (long)gr.getChildResults().size();
            GroupResult ngr = new GroupResult(gr);
            this.childResults.add(ngr);
        }
        this.updateStatus(this.childResults);
    }

    public long getTotalRan() {
        return this.totalRan;
    }

    public List<GroupResult> getChildResults() {
        return this.childResults;
    }

    public void setChildResults(List<GroupResult> childResults) {
        this.childResults = childResults;
        this.updateStatus(childResults);
    }

    public void addChildResult(GroupResult childResult) {
        this.childResults.add(childResult);
        this.updateStatus(Arrays.asList(childResult));
    }

    private void updateStatus(List<GroupResult> childResults) {
        Result.Type curtype = Result.Type.PASSED;
        for (GroupResult child : childResults) {
            curtype = this.compareStatus(curtype, child.getResult().getStatus());
        }
        Result res = this.getResult();
        this.setResult(new Result(Result.Type.valueOf((String)curtype.name()), res.getDuration(), res.getError()));
    }

    private Result.Type compareStatus(Result.Type curtype, Result.Type compare) {
        switch (compare) {
            case PASSED: {
                break;
            }
            case SKIPPED: {
                if (Result.Type.SKIPPED.ordinal() <= curtype.ordinal()) break;
                curtype = Result.Type.SKIPPED;
                break;
            }
            case PENDING: {
                if (Result.Type.PENDING.ordinal() <= curtype.ordinal()) break;
                curtype = Result.Type.PENDING;
                break;
            }
            case UNDEFINED: {
                if (Result.Type.UNDEFINED.ordinal() <= curtype.ordinal()) break;
                curtype = Result.Type.UNDEFINED;
                break;
            }
            case AMBIGUOUS: {
                if (Result.Type.AMBIGUOUS.ordinal() <= curtype.ordinal()) break;
                curtype = Result.Type.AMBIGUOUS;
                break;
            }
            case FAILED: {
                if (Result.Type.FAILED.ordinal() <= curtype.ordinal()) break;
                curtype = Result.Type.FAILED;
            }
        }
        return curtype;
    }
}

