/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.api.result;

import cucumber.api.PickleStepTestStep;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.perf.api.result.StepResult;
import cucumber.perf.api.result.TestStep;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

public class StepResultListener
implements EventListener {
    static final String UNDEFINED_MESSAGE = "There are undefined steps";
    private LocalDateTime start = null;
    private List<StepResult> results = new ArrayList<StepResult>();
    private String name;
    private final EventHandler<TestStepFinished> testStepFinishedHandler = new EventHandler<TestStepFinished>(){

        public void receive(TestStepFinished event) {
            StepResultListener.this.results.add(new StepResult(StepResultListener.this.name, new TestStep(event.testStep), event.result, StepResultListener.this.start, LocalDateTime.now()));
        }
    };
    private final EventHandler<TestStepStarted> testStepStartedHandler = new EventHandler<TestStepStarted>(){

        public void receive(TestStepStarted event) {
            StepResultListener.this.start = LocalDateTime.now();
            StepResultListener.this.name = ((PickleStepTestStep)event.testStep).getStepText();
        }
    };

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestStepFinished.class, this.testStepFinishedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.testStepStartedHandler);
    }

    public List<StepResult> getResults() {
        return this.results;
    }

    public void reset() {
        this.results = new ArrayList<StepResult>();
    }
}

