/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.api.result;

import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.perf.api.result.ScenarioResult;
import cucumber.perf.api.result.TestCase;
import java.time.LocalDateTime;

public class TestCaseResultListener
implements EventListener {
    static final String UNDEFINED_MESSAGE = "There are undefined steps";
    private LocalDateTime start = LocalDateTime.now();
    private ScenarioResult result = null;
    private String name;
    private final EventHandler<TestCaseFinished> testCaseFinishedHandler = new EventHandler<TestCaseFinished>(){

        public void receive(TestCaseFinished event) {
            TestCaseResultListener.this.result = new ScenarioResult(TestCaseResultListener.this.name, new TestCase(event.testCase), event.result, TestCaseResultListener.this.start, LocalDateTime.now());
        }
    };
    private final EventHandler<TestCaseStarted> testCaseStartedHandler = new EventHandler<TestCaseStarted>(){

        public void receive(TestCaseStarted event) {
            TestCaseResultListener.this.start = LocalDateTime.now();
            TestCaseResultListener.this.name = event.testCase.getName();
        }
    };

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseFinished.class, this.testCaseFinishedHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.testCaseStartedHandler);
    }

    public ScenarioResult getResult() {
        return this.result;
    }
}

