/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.runtime;

import cucumber.api.Result;
import cucumber.perf.api.FeatureBuilder;
import cucumber.perf.api.PerfGroup;
import cucumber.perf.api.PerfPlan;
import cucumber.perf.api.PlanBuilder;
import cucumber.perf.api.event.GroupFinished;
import cucumber.perf.api.event.GroupStarted;
import cucumber.perf.api.event.PerfRunFinished;
import cucumber.perf.api.event.PerfRunStarted;
import cucumber.perf.api.event.SimulationFinished;
import cucumber.perf.api.event.SimulationStarted;
import cucumber.perf.api.result.GroupResult;
import cucumber.perf.api.result.SimulationResult;
import cucumber.perf.runtime.CucumberRunner;
import cucumber.perf.runtime.PerfRuntimeOptions;
import cucumber.perf.runtime.PerfRuntimeOptionsFactory;
import cucumber.perf.runtime.RunnerOptions;
import cucumber.perf.runtime.TimeServiceEventBus;
import cucumber.perf.runtime.filter.FeatureFilter;
import cucumber.perf.runtime.filter.Filters;
import cucumber.perf.runtime.formatter.PluginFactory;
import cucumber.perf.runtime.formatter.Plugins;
import cucumber.perf.salad.ast.Group;
import cucumber.perf.salad.ast.SaladDocument;
import cucumber.perf.salad.ast.Simulation;
import cucumber.perf.salad.ast.SimulationDefinition;
import cucumber.perf.salad.ast.SimulationPeriod;
import cucumber.runner.TimeService;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.model.CucumberFeature;
import gherkin.ast.Tag;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadLocalRandom;

public class CucumberPerf {
    private int maxThreads = 10;
    private ExecutorService pool = null;
    private Filters filters;
    private Class<?> clazz = null;
    private List<CucumberFeature> features = null;
    private FeatureFilter featureFilter = null;
    private PerfRuntimeOptions options = null;
    private Plugins plugins = null;
    private List<PerfPlan> plans = null;
    private long ranCount = 0L;
    private long totalRanCount = 0L;
    private int runningCount = 0;
    private List<PerfGroup> groups = null;
    private List<List<FutureTask<Object>>> running = new ArrayList<List<FutureTask<Object>>>();
    private List<GroupResult> finished = new ArrayList<GroupResult>();
    private LocalDateTime start = LocalDateTime.now();
    private LocalDateTime end = LocalDateTime.now();
    private Duration wait = null;
    private long maxRan = 0L;
    private int maxRampPeriods = 10;
    private TimeServiceEventBus eventBus = new TimeServiceEventBus(TimeService.SYSTEM);

    public CucumberPerf(Class<?> clazz) {
        this.clazz = clazz;
        this.options = new PerfRuntimeOptionsFactory(clazz).create();
        RuntimeOptions ro = FeatureBuilder.createRuntimeOptions(clazz);
        this.buildRuntime(ro);
    }

    public CucumberPerf(Class<?> clazz, PerfRuntimeOptions options) {
        this.clazz = clazz;
        this.options = options;
        RuntimeOptions ro = FeatureBuilder.createRuntimeOptions(clazz);
        this.buildRuntime(ro);
    }

    public CucumberPerf(PerfRuntimeOptions options) {
        this.options = options;
        RuntimeOptions ro = FeatureBuilder.createRuntimeOptions(options.getCucumberOptions());
        this.buildRuntime(ro);
    }

    public CucumberPerf(String[] args) {
        this.options = new PerfRuntimeOptions(Arrays.asList(args));
        RuntimeOptions ro = FeatureBuilder.createRuntimeOptions(this.options.getCucumberOptions());
        this.buildRuntime(ro);
    }

    public void runThreads() throws Throwable {
        this.eventBus.send(new PerfRunStarted(this.eventBus.getTime(), (long)this.eventBus.getTimeMillis()));
        this.plans = PlanBuilder.LoadPlans(this.getClass(), new ArrayList<String>(this.options.getPlanPaths()));
        if (this.plans != null && !this.plans.isEmpty()) {
            for (int p = 0; p < this.plans.size(); ++p) {
                SaladDocument pl = this.plans.get(p).getSaladPlan();
                for (int s = 0; s < pl.getPlan().getChildren().size(); ++s) {
                    if (!this.matchFilters(pl, s)) continue;
                    boolean executing = true;
                    SimulationDefinition sim = pl.getPlan().getChildren().get(s);
                    this.eventBus.send(new SimulationStarted(this.eventBus.getTime(), this.eventBus.getTimeMillis(), sim.getName()));
                    LocalDateTime start = LocalDateTime.now();
                    this.buildGroups(sim);
                    this.setMaxRan();
                    this.setMaxThreads();
                    this.ranCount = 0L;
                    this.pool = Executors.newFixedThreadPool(this.maxThreads);
                    String scheduledRuntime = null;
                    String rampUp = null;
                    String rampDown = null;
                    if (sim instanceof SimulationPeriod) {
                        scheduledRuntime = ((SimulationPeriod)sim).getTime().getText();
                        rampUp = ((SimulationPeriod)sim).getRampUp() != null ? ((SimulationPeriod)sim).getRampUp().getText() : null;
                        rampDown = ((SimulationPeriod)sim).getRampDown() != null ? ((SimulationPeriod)sim).getRampDown().getText() : null;
                    } else {
                        rampUp = ((Simulation)sim).getRampUp() != null ? ((Simulation)sim).getRampUp().getText() : null;
                        rampDown = ((Simulation)sim).getRampDown() != null ? ((Simulation)sim).getRampDown().getText() : null;
                    }
                    LocalDateTime beginEnd = null;
                    LocalDateTime endRamp = null;
                    LocalDateTime nextRamp = null;
                    long rampPeriod = 0L;
                    int curPercent = 0;
                    LocalDateTime curTime = LocalDateTime.now();
                    if (scheduledRuntime != null) {
                        beginEnd = this.getEnd(curTime, scheduledRuntime);
                    }
                    if (rampUp != null) {
                        endRamp = this.getEnd(curTime, rampUp);
                        rampPeriod = this.getRampPeriod(Duration.between(curTime, endRamp), this.maxRampPeriods);
                        nextRamp = this.getEnd(curTime, rampPeriod);
                        this.setCurGroupThreads(0);
                    }
                    while (!this.options.isDryRun() && executing) {
                        curTime = LocalDateTime.now();
                        if (endRamp == null) {
                            if (beginEnd != null && curTime.isAfter(beginEnd) || this.ranCount >= this.maxRan && beginEnd == null) {
                                if (rampDown == null) {
                                    executing = false;
                                } else {
                                    endRamp = this.getEnd(curTime, rampDown);
                                    rampPeriod = this.getRampPeriod(Duration.between(curTime, endRamp), this.maxRampPeriods);
                                    nextRamp = this.getEnd(curTime, rampPeriod);
                                }
                            }
                        } else if (curTime.isAfter(endRamp)) {
                            endRamp = null;
                            nextRamp = null;
                            if (rampUp == null) {
                                rampDown = null;
                                executing = false;
                            } else {
                                rampUp = null;
                                curPercent = 100;
                                this.setCurGroupThreads(curPercent);
                            }
                        } else if (nextRamp != null && curTime.isAfter(nextRamp)) {
                            curPercent = rampUp == null ? (curPercent -= 100 / this.maxRampPeriods) : (curPercent += 100 / this.maxRampPeriods);
                            this.setCurGroupThreads(curPercent);
                            nextRamp = this.getEnd(curTime, rampPeriod);
                        }
                        if (this.runningCount < this.maxThreads) {
                            int i;
                            int n = i = this.runningCount > 0 ? this.runningCount - 1 : 0;
                            while (i < this.maxThreads) {
                                CucumberRunner runner = null;
                                int loc = ThreadLocalRandom.current().nextInt(0, 99999999);
                                for (int l = 0; runner == null && l < this.groups.size(); ++l) {
                                    PerfGroup pg = this.groups.get((loc + l) % this.groups.size());
                                    if (pg.getRunning() >= pg.getThreads() || scheduledRuntime == null && pg.getRan() >= pg.getCount()) continue;
                                    RunnerOptions ro = new RunnerOptions(pg);
                                    if (this.options.getCucumberOptions() != null && this.options.getCucumberOptions().size() > 0) {
                                        runner = new CucumberRunner(ro, this.options.getCucumberOptions(), this.wait, this.options.isFailFast());
                                    }
                                    runner = new CucumberRunner(ro, this.clazz, this.wait, this.options.isFailFast());
                                    loc = (loc + l) % this.groups.size();
                                    pg.incrementRunning();
                                    this.eventBus.send(new GroupStarted(this.eventBus.getTime(), this.eventBus.getTimeMillis(), p, pg));
                                }
                                if (runner != null) {
                                    FutureTask task = new FutureTask(runner);
                                    this.pool.execute(task);
                                    this.running.get(loc).add(task);
                                    ++this.ranCount;
                                    ++this.runningCount;
                                }
                                ++i;
                            }
                        }
                        int gc = 0;
                        for (List<FutureTask<Object>> g : this.running) {
                            for (int r = 0; r < g.size(); ++r) {
                                if (!g.get(r).isDone()) continue;
                                this.finished.add((GroupResult)g.get(r).get());
                                this.eventBus.send(new GroupFinished(this.eventBus.getTime(), this.eventBus.getTimeMillis(), gc, this.groups.get(gc), (GroupResult)g.get(r).get()));
                                g.remove(r);
                                --this.runningCount;
                                this.groups.get(gc).decrementRunning();
                            }
                            ++gc;
                        }
                    }
                    this.totalRanCount += this.ranCount;
                    this.waitForFinished(60);
                    this.eventBus.send(new SimulationFinished(this.eventBus.getTime(), this.eventBus.getTimeMillis(), new SimulationResult(sim.getName(), new Result(Result.Type.PASSED, Long.valueOf(Duration.between(start, LocalDateTime.now()).getSeconds()), null), start, LocalDateTime.now(), this.finished)));
                }
            }
        }
        this.end = LocalDateTime.now();
        this.eventBus.send(new PerfRunFinished(this.eventBus.getTime(), (long)this.eventBus.getTimeMillis()));
    }

    private void buildRuntime(RuntimeOptions ro) {
        this.features = FeatureBuilder.getFeatures(ro);
        this.featureFilter = new FeatureFilter(this.features);
        this.warnProgressFormatter(ro);
        this.filters = new Filters(this.options);
        PluginFactory pf = new PluginFactory();
        this.plugins = new Plugins(this.getClass().getClassLoader(), pf, this.options);
        this.plugins.setEventBusOnPlugins(this.eventBus);
    }

    private boolean matchFilters(SaladDocument pl, int s) {
        SimulationDefinition si = null;
        if (pl.getPlan().getChildren().get(s) instanceof Simulation) {
            Simulation sim = (Simulation)pl.getPlan().getChildren().get(s);
            ArrayList<Tag> t = new ArrayList<Tag>(pl.getPlan().getTags());
            t.addAll(sim.getTags());
            si = new Simulation(t, sim.getLocation(), sim.getKeyword(), sim.getName(), sim.getDescription(), sim.getGroups(), sim.getRampDown(), sim.getRampDown(), sim.getSynchronize(), sim.getRandomWait());
        } else if (pl.getPlan().getChildren().get(s) instanceof SimulationPeriod) {
            SimulationPeriod sim = (SimulationPeriod)pl.getPlan().getChildren().get(s);
            ArrayList<Tag> t = new ArrayList<Tag>(pl.getPlan().getTags());
            t.addAll(sim.getTags());
            si = new SimulationPeriod(t, sim.getLocation(), sim.getKeyword(), sim.getName(), sim.getDescription(), sim.getGroups(), sim.getTime(), sim.getRampDown(), sim.getRampDown(), sim.getSynchronize(), sim.getRandomWait());
        }
        return this.filters.matchesFilters(si);
    }

    private void buildGroups(SimulationDefinition sim) {
        if (sim instanceof Simulation) {
            this.wait = ((Simulation)sim).getRandomWait() != null ? this.convertRuntime(((Simulation)sim).getRandomWait().getText()) : null;
        } else if (sim instanceof SimulationPeriod) {
            Duration duration = this.wait = ((SimulationPeriod)sim).getRandomWait() != null ? this.convertRuntime(((SimulationPeriod)sim).getRandomWait().getText()) : null;
        }
        if (this.wait != null && (this.wait.isZero() || this.wait.isNegative())) {
            this.wait = null;
            System.err.println("WARNING: Random wait is not a valid duration. It will be ignored.");
        }
        this.groups = new ArrayList<PerfGroup>();
        this.running = new ArrayList<List<FutureTask<Object>>>();
        for (Group g : sim.getGroups()) {
            PerfGroup pg = new PerfGroup(g);
            pg.setFeatures(this.getFeatures(pg));
            this.groups.add(pg);
            this.running.add(new ArrayList());
        }
    }

    private void waitForFinished(int timeout) {
        for (int count = 0; count < timeout && !this.isFinished(); ++count) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private boolean isFinished() {
        int gc = 0;
        if (this.running.isEmpty()) {
            return true;
        }
        for (List<FutureTask<Object>> g : this.running) {
            for (int r = 0; r < g.size(); ++r) {
                if (!g.get(r).isDone()) continue;
                try {
                    this.finished.add((GroupResult)g.get(r).get());
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
                g.remove(r);
                --this.runningCount;
                this.groups.get(gc).decrementRunning();
                this.eventBus.send(new GroupFinished(this.eventBus.getTime(), this.eventBus.getTimeMillis(), gc, this.groups.get(gc), this.finished.get(this.finished.size() - 1)));
            }
            if (!g.isEmpty()) {
                return false;
            }
            ++gc;
        }
        return true;
    }

    public void printResult() {
        System.out.println("Total Ran: " + this.getTotalRanCount());
        System.out.println("RunTime: " + this.getRunTime());
    }

    public Duration convertRuntime(String time) {
        Duration d = Duration.between(LocalTime.MIN, LocalTime.parse(time));
        return d;
    }

    public LocalDateTime getEnd(LocalDateTime start, String time) {
        LocalDateTime endt = LocalDateTime.from(start).plus(this.convertRuntime(time));
        return endt;
    }

    private LocalDateTime getEnd(LocalDateTime start, long timeSeconds) {
        LocalDateTime endt = LocalDateTime.from(start).plus(timeSeconds, ChronoUnit.SECONDS);
        return endt;
    }

    public long getMaxRan() {
        return this.maxRan;
    }

    private void setMaxRan() {
        this.maxRan = 0L;
        for (PerfGroup pg : this.groups) {
            this.maxRan += (long)pg.getCount();
        }
    }

    private void setMaxThreads() {
        this.maxThreads = 0;
        for (PerfGroup pg : this.groups) {
            this.maxThreads += pg.getThreads();
        }
    }

    private void setCurGroupThreads(int percent) {
        float per = 1.0f;
        if (percent < 100) {
            per = percent > 0 ? (float)percent / 100.0f : 0.0f;
        }
        this.maxThreads = 0;
        for (PerfGroup pg : this.groups) {
            pg.setThreads(Math.round((float)pg.getMaxThreads() * per));
            this.maxThreads += pg.getThreads();
        }
    }

    private long getRampPeriod(Duration time, int times) {
        return time.getSeconds() / (long)times;
    }

    private List<CucumberFeature> getFeatures(PerfGroup pg) {
        return this.featureFilter.filter(pg.getText());
    }

    private void warnProgressFormatter(RuntimeOptions runtimeOptions) {
        for (String plugin : runtimeOptions.getPluginNames()) {
            if (plugin.equalsIgnoreCase("progress")) {
                this.options.disableDisplay();
                System.out.println("WARNING: Cucumber options contains Progress formatter.");
                System.out.println("\tThis is enabled by default in Cucumber when no formatter is passed in.");
                System.out.println("\tDisabling all display printers. To enable pass in plugin \"cucumber.formatter.NullFormatter\"");
                continue;
            }
            if (!plugin.equalsIgnoreCase("default_summary")) continue;
            this.options.disableDisplay();
            System.out.println("WARNING: Cucumber options contains default summary.");
            System.out.println("\tThis is enabled by default in Cucumber when no formatter is passed in.");
            System.out.println("\tDisabling all display printers. To enable pass in plugin \"null_summary\"");
        }
    }

    public long getTotalRanCount() {
        return this.totalRanCount;
    }

    public LocalDateTime getStart() {
        return this.start;
    }

    public LocalDateTime getEnd() {
        return this.end;
    }

    public String getRunTime() {
        Duration d = Duration.between(this.start, this.end);
        return d.toString();
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public Plugins getPlugins() {
        return this.plugins;
    }
}

