/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.runtime;

import cucumber.api.Result;
import cucumber.api.event.Event;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestRunStarted;
import cucumber.perf.api.FeatureBuilder;
import cucumber.perf.api.PerfCompiler;
import cucumber.perf.api.result.GroupResult;
import cucumber.perf.api.result.GroupResultListener;
import cucumber.perf.api.result.ScenarioResult;
import cucumber.perf.api.result.StepResultListener;
import cucumber.perf.api.result.TestCaseResultListener;
import cucumber.perf.runtime.RunnerOptions;
import cucumber.perf.salad.ast.Slice;
import cucumber.runner.EventBus;
import cucumber.runner.RunnerSupplier;
import cucumber.runner.ThreadLocalRunnerSupplier;
import cucumber.runner.TimeService;
import cucumber.runner.TimeServiceEventBus;
import cucumber.runtime.BackendModuleBackendSupplier;
import cucumber.runtime.BackendSupplier;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.FeaturePathFeatureSupplier;
import cucumber.runtime.FeatureSupplier;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.RuntimeOptionsFactory;
import cucumber.runtime.filter.Filters;
import cucumber.runtime.formatter.PluginFactory;
import cucumber.runtime.formatter.Plugins;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.FeatureLoader;
import gherkin.ast.ScenarioDefinition;
import gherkin.events.PickleEvent;
import io.cucumber.core.options.FeatureOptions;
import io.cucumber.core.options.FilterOptions;
import io.cucumber.core.options.PluginOptions;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;

public class CucumberRunner
implements Callable<Object> {
    private RuntimeOptions runtimeOptions;
    private RunnerSupplier runnerSupplier;
    private EventBus eventBus = new TimeServiceEventBus(TimeService.SYSTEM);
    private Filters filters;
    private FeatureSupplier featureSupplier;
    private Plugins plugins;
    private GroupResultListener resultListener;
    private TestCaseResultListener testCaseResultListener;
    private StepResultListener stepResultListener;
    private Duration wait = null;
    private boolean failFast = false;
    List<ScenarioResult> scenarioResults = new ArrayList<ScenarioResult>();
    private RunnerOptions options;

    private void randomWait() {
        if (this.wait != null) {
            try {
                long mean = this.wait.toMillis();
                Thread.sleep(ThreadLocalRandom.current().nextLong(mean / 2L, mean + mean / 2L));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public CucumberRunner(RunnerOptions options, List<String> args, Duration wait, boolean failFast) {
        this.wait = wait;
        this.failFast = failFast;
        this.options = options;
        this.runtimeOptions = new RuntimeOptions(args);
        this.BuildRuntime();
        this.configListeners();
    }

    public CucumberRunner(RunnerOptions options, Class<?> clazz, Duration wait, boolean failFast) {
        this.wait = wait;
        this.failFast = failFast;
        this.options = options;
        RuntimeOptionsFactory runtimeOptionsFactory = new RuntimeOptionsFactory(clazz);
        this.runtimeOptions = runtimeOptionsFactory.create();
        this.BuildRuntime();
        this.configListeners();
    }

    private void configListeners() {
        for (CucumberFeature feature : this.options.getFeatures()) {
            feature.sendTestSourceRead(this.eventBus);
        }
        this.resultListener = new GroupResultListener();
        this.resultListener.setEventPublisher((EventPublisher)this.eventBus);
        this.resultListener.setGroupName(this.options.getGroupText());
        this.testCaseResultListener = new TestCaseResultListener();
        this.testCaseResultListener.setEventPublisher((EventPublisher)this.eventBus);
        this.stepResultListener = new StepResultListener();
        this.stepResultListener.setEventPublisher((EventPublisher)this.eventBus);
    }

    @Override
    public Object call() {
        List<CucumberFeature> features = this.getFeatures();
        GroupResult result = null;
        this.randomWait();
        try {
            this.start();
            for (CucumberFeature f : features) {
                this.runFeature(f, this.options.getSlice());
            }
            this.finish();
            result = this.resultListener.getResult();
            result.setChildResults(this.scenarioResults);
        }
        catch (Throwable e) {
            result = this.resultListener.getResult() != null ? this.resultListener.getResult() : new GroupResult(this.options.getGroupText(), new Result(Result.Type.FAILED, Long.valueOf(0L), e), LocalDateTime.now(), LocalDateTime.now());
            result.setChildResults(this.scenarioResults);
        }
        return result;
    }

    private void runFeature(CucumberFeature cucumberFeature, Slice slice) throws Throwable {
        PerfCompiler compiler = new PerfCompiler();
        List<PickleEvent> pickles = compiler.compileFeature(cucumberFeature, slice);
        for (PickleEvent pickle : pickles) {
            if (!this.filters.matchesFilters(pickle)) continue;
            this.runScenario(pickle);
        }
    }

    private void runScenario(PickleEvent pickle) throws Throwable {
        this.runnerSupplier.get().runPickle(pickle);
        ScenarioResult sr = this.testCaseResultListener.getResult();
        sr.setChildResults(this.stepResultListener.getResults());
        this.scenarioResults.add(sr);
        this.stepResultListener.reset();
        if (this.failFast && !this.testCaseResultListener.getResult().isPassed()) {
            throw this.testCaseResultListener.getResult().getError();
        }
    }

    private void start() {
        this.eventBus.send((Event)new TestRunStarted(this.eventBus.getTime(), this.eventBus.getTimeMillis().longValue()));
    }

    private void finish() {
        this.eventBus.send((Event)new TestRunFinished(this.eventBus.getTime(), this.eventBus.getTimeMillis().longValue()));
    }

    private void BuildRuntime() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        MultiLoader resourceLoader = new MultiLoader(classLoader);
        ResourceLoaderClassFinder classFinder = new ResourceLoaderClassFinder((ResourceLoader)resourceLoader, classLoader);
        BackendModuleBackendSupplier backendSupplier = new BackendModuleBackendSupplier((ResourceLoader)resourceLoader, (ClassFinder)classFinder, (io.cucumber.core.options.RunnerOptions)this.runtimeOptions);
        this.plugins = new Plugins(classLoader, new PluginFactory(), (EventPublisher)this.eventBus, (PluginOptions)this.runtimeOptions);
        this.runnerSupplier = new ThreadLocalRunnerSupplier((io.cucumber.core.options.RunnerOptions)this.runtimeOptions, this.eventBus, (BackendSupplier)backendSupplier);
        FeatureLoader featureLoader = new FeatureLoader((ResourceLoader)resourceLoader);
        this.featureSupplier = new FeaturePathFeatureSupplier(featureLoader, (FeatureOptions)this.runtimeOptions);
        this.filters = new Filters((FilterOptions)this.runtimeOptions);
    }

    public List<CucumberFeature> getFeatures() {
        if (this.options.getFeatures() == null) {
            return this.featureSupplier.get();
        }
        return this.options.getFeatures();
    }

    public List<List<ScenarioDefinition>> getScenarios() {
        return FeatureBuilder.GetScenarios(this.getFeatures());
    }
}

