/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.runtime;

import cucumber.perf.runtime.formatter.PluginFactory;
import cucumber.perf.salad.SaladDialect;
import cucumber.perf.salad.SaladDialectProvider;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Shellwords;
import cucumber.util.FixJava;
import cucumber.util.Mapper;
import io.cucumber.datatable.DataTable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;

public class PerfRuntimeOptions {
    public static final String VERSION = ResourceBundle.getBundle("cucumber.version").getString("cucumber-jvm.version");
    public static final String USAGE_RESOURCE = "/USAGE.txt";
    static String usageText;
    private static final Mapper<String, String> QUOTE_MAPPER;
    private final List<String> tagFilters = new ArrayList<String>();
    private final List<Pattern> nameFilters = new ArrayList<Pattern>();
    private final List<String> planPaths = new ArrayList<String>();
    private final List<String> cucumberOptions = new ArrayList<String>();
    private final List<String> pluginFormatterNames = new ArrayList<String>();
    private List<String> pluginDisplayNames = new ArrayList<String>();
    private final List<String> pluginSummaryPrinterNames = new ArrayList<String>();
    private boolean dryRun;
    private boolean strict = true;
    private boolean monochrome = false;
    private boolean failFast = false;

    public PerfRuntimeOptions() {
        this(new ArrayList<String>());
    }

    public PerfRuntimeOptions(List<String> argv) {
        argv = new ArrayList<String>(argv);
        List<String> ls = this.parse(argv);
        this.addCucumberOptions(ls);
        if (this.pluginFormatterNames.isEmpty() || !this.pluginFormatterNames.contains("statistics")) {
            this.pluginFormatterNames.add("statistics");
        }
        if (this.pluginSummaryPrinterNames.isEmpty()) {
            this.pluginSummaryPrinterNames.add("default_summary");
        }
    }

    private List<String> parse(List<String> args) {
        ArrayList<String> list = new ArrayList<String>();
        ParsedPluginData parsedPluginData = new ParsedPluginData();
        for (String arg : args) {
            if (arg.startsWith("tags=") || arg.startsWith("t=")) {
                this.tagFilters.add(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("name=") || arg.startsWith("n=")) {
                String nextArg = arg.split("=")[1];
                Pattern patternFilter = Pattern.compile(nextArg);
                this.nameFilters.add(patternFilter);
                continue;
            }
            if (arg.startsWith("plans=") || arg.startsWith("p=")) {
                this.planPaths.add(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("plugin=") || arg.startsWith("pg=") || arg.startsWith("add-plugin=")) {
                parsedPluginData.addPluginName(arg.split("=")[1], arg.startsWith("add-plugin="));
                continue;
            }
            if (arg.startsWith("dryrun")) {
                this.dryRun = true;
                continue;
            }
            if (arg.startsWith("monochrome")) {
                this.monochrome = true;
                continue;
            }
            if (arg.startsWith("failfast")) {
                this.failFast = true;
                continue;
            }
            if (arg.equals("help") || arg.equals("h")) {
                this.printUsage();
                System.exit(0);
                continue;
            }
            if (arg.startsWith("i18n=")) {
                System.exit(this.printI18n(arg.split("=")[1]));
                continue;
            }
            if (arg.equals("version") || arg.equals("v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (arg.equals("no-strict")) {
                this.strict = false;
                continue;
            }
            list.add(arg);
        }
        parsedPluginData.updatePluginFormatterNames(this.pluginFormatterNames);
        parsedPluginData.updatePluginDisplayNames(this.pluginDisplayNames);
        parsedPluginData.updatePluginSummaryPrinterNames(this.pluginSummaryPrinterNames);
        return list;
    }

    private void printUsage() {
        PerfRuntimeOptions.loadUsageTextIfNeeded();
        System.out.println(usageText);
    }

    static void loadUsageTextIfNeeded() {
        if (usageText == null) {
            try {
                InputStreamReader reader = new InputStreamReader(FixJava.class.getResourceAsStream(USAGE_RESOURCE), "UTF-8");
                usageText = FixJava.readReader((Reader)reader);
            }
            catch (Exception e) {
                usageText = "Could not load usage text: " + e.toString();
            }
        }
    }

    private int printI18n(String language) {
        SaladDialectProvider dialectProvider = new SaladDialectProvider();
        List<String> languages = dialectProvider.getLanguages();
        if (language.equalsIgnoreCase("help")) {
            for (String code : languages) {
                System.out.println(code);
            }
            return 0;
        }
        if (languages.contains(language)) {
            return this.printKeywordsFor(dialectProvider.getDialect(language, null));
        }
        System.err.println("Unrecognised ISO language code");
        return 1;
    }

    private int printKeywordsFor(SaladDialect dialect) {
        StringBuilder builder = new StringBuilder();
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        this.addKeywordRow(table, "plan", dialect.getPlanKeywords());
        this.addKeywordRow(table, "simulation", dialect.getSimulationKeywords());
        this.addKeywordRow(table, "simulation period", dialect.getSimulationPeriodKeywords());
        this.addKeywordRow(table, "group", dialect.getGroupKeywords());
        this.addKeywordRow(table, "count", dialect.getCountKeywords());
        this.addKeywordRow(table, "runners", dialect.getRunnersKeywords());
        this.addKeywordRow(table, "rampup", dialect.getRampUpKeywords());
        this.addKeywordRow(table, "rampdown", dialect.getRampDownKeywords());
        this.addKeywordRow(table, "time", dialect.getTimeKeywords());
        this.addKeywordRow(table, "synchronized", dialect.getSynchronizedKeywords());
        this.addKeywordRow(table, "randomwait", dialect.getRandomWaitKeywords());
        DataTable.create(table).print(builder);
        System.out.println(builder.toString());
        return 0;
    }

    private void addKeywordRow(List<List<String>> table, String key, List<String> keywords) {
        List<String> cells = Arrays.asList(key, FixJava.join((List)FixJava.map(keywords, QUOTE_MAPPER), (String)", "));
        table.add(cells);
    }

    public List<String> getPluginsNames() {
        ArrayList<String> plugins = new ArrayList<String>();
        plugins.addAll(this.pluginFormatterNames);
        plugins.addAll(this.pluginSummaryPrinterNames);
        plugins.addAll(this.pluginDisplayNames);
        return plugins;
    }

    private boolean isCucumberPlugin(String string) throws Exception {
        if (cucumber.runtime.formatter.PluginFactory.isSummaryPrinterName((String)string)) {
            return true;
        }
        if (cucumber.runtime.formatter.PluginFactory.isFormatterName((String)string)) {
            return true;
        }
        return cucumber.runtime.formatter.PluginFactory.isStepDefinitionReporterName((String)string);
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isMonochrome() {
        return this.monochrome;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public List<String> getPlanPaths() {
        return this.planPaths;
    }

    public List<Pattern> getNameFilters() {
        return this.nameFilters;
    }

    public List<String> getTagFilters() {
        return this.tagFilters;
    }

    public List<String> getCucumberOptions() {
        return this.cucumberOptions;
    }

    public PerfRuntimeOptions addPlanPaths(List<String> planPaths) {
        this.planPaths.addAll(planPaths);
        return this;
    }

    public PerfRuntimeOptions addNameFilters(List<String> nameFilters) {
        for (String nf : nameFilters) {
            Pattern patternFilter = Pattern.compile(nf);
            this.nameFilters.add(patternFilter);
        }
        return this;
    }

    public PerfRuntimeOptions addTagFilters(List<String> tagFilters) {
        this.tagFilters.addAll(tagFilters);
        return this;
    }

    public PerfRuntimeOptions addPlugins(List<String> plugins) {
        for (String plugin : plugins) {
            if (PluginFactory.isDisplayName(plugin)) {
                this.pluginDisplayNames.add(plugin);
                continue;
            }
            if (PluginFactory.isFormatterName(plugin)) {
                this.pluginFormatterNames.add(plugin);
                continue;
            }
            if (!PluginFactory.isSummaryPrinterName(plugin)) continue;
            this.pluginSummaryPrinterNames.add(plugin);
        }
        return this;
    }

    public void disableDisplay() {
        this.pluginDisplayNames = new ArrayList<String>();
    }

    public PerfRuntimeOptions addCucumberOptions(List<String> args) {
        for (String arg : args) {
            List ca = Shellwords.parse((String)arg);
            int p = 0;
            boolean ispretty = false;
            for (int i = 0; i < ca.size(); ++i) {
                if (((String)ca.get(i)).contentEquals("-p")) {
                    p = i;
                }
                if (((String)ca.get(i)).contains("pretty")) {
                    ca.remove(i);
                    --i;
                    ispretty = true;
                }
                try {
                    if (!ispretty || !((String)ca.get(i)).contentEquals("-p") && this.isCucumberPlugin((String)ca.get(i))) continue;
                    ispretty = false;
                    ca.remove(p);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.cucumberOptions.addAll(ca);
        }
        return this;
    }

    static {
        QUOTE_MAPPER = new Mapper<String, String>(){

            public String map(String o) {
                return '\"' + o + '\"';
            }
        };
    }

    class ParsedOptionNames {
        private List<String> names = new ArrayList<String>();
        private boolean clobber = false;

        ParsedOptionNames() {
        }

        public void addName(String name, boolean isAddOption) {
            this.names.add(name);
            if (!isAddOption) {
                this.clobber = true;
            }
        }

        public void updateNameList(List<String> nameList) {
            if (!this.names.isEmpty()) {
                if (this.clobber) {
                    nameList.clear();
                }
                nameList.addAll(this.names);
            }
        }
    }

    class ParsedPluginData {
        ParsedOptionNames formatterNames;
        ParsedOptionNames displayNames;
        ParsedOptionNames summaryPrinterNames;

        ParsedPluginData() {
            this.formatterNames = new ParsedOptionNames();
            this.displayNames = new ParsedOptionNames();
            this.summaryPrinterNames = new ParsedOptionNames();
        }

        public void addPluginName(String name, boolean isAddPlugin) {
            if (PluginFactory.isFormatterName(name)) {
                this.formatterNames.addName(name, isAddPlugin);
            } else if (PluginFactory.isDisplayName(name)) {
                this.displayNames.addName(name, isAddPlugin);
            } else if (PluginFactory.isSummaryPrinterName(name)) {
                this.summaryPrinterNames.addName(name, isAddPlugin);
            } else {
                throw new CucumberException("Unrecognized plugin: " + name);
            }
        }

        public void updatePluginFormatterNames(List<String> pluginFormatterNames) {
            this.formatterNames.updateNameList(pluginFormatterNames);
        }

        public void updatePluginDisplayNames(List<String> pluginDisplayNames) {
            this.displayNames.updateNameList(pluginDisplayNames);
        }

        public void updatePluginSummaryPrinterNames(List<String> pluginSummaryPrinterNames) {
            this.summaryPrinterNames.updateNameList(pluginSummaryPrinterNames);
        }
    }
}

