/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.runtime;

import cucumber.perf.api.CucumberPerfOptions;
import cucumber.perf.runtime.PerfRuntimeOptions;
import java.util.ArrayList;
import java.util.List;

public class PerfRuntimeOptionsFactory {
    private final Class<?> clazz;
    private boolean plansSpecified = false;

    public PerfRuntimeOptionsFactory(Class<?> clazz) {
        this.clazz = clazz;
    }

    public PerfRuntimeOptions create() {
        List<String> args = this.buildArgsFromOptions();
        return new PerfRuntimeOptions(args);
    }

    private List<String> buildArgsFromOptions() {
        ArrayList<String> args = new ArrayList<String>();
        Class<?> classWithOptions = this.clazz;
        while (this.hasSuperClass(classWithOptions)) {
            CucumberPerfOptions options = this.getOptions(classWithOptions);
            if (options != null) {
                this.addDryRun(options, args);
                this.addTags(options, args);
                this.addName(options, args);
                this.addPlans(options, args);
                this.addPlugins(options, args);
            }
            classWithOptions = classWithOptions.getSuperclass();
        }
        this.addDefaultPlanPathIfNoPlanPathIsSpecified(args, this.clazz);
        return args;
    }

    private void addName(CucumberPerfOptions options, List<String> args) {
        for (String name : options.name()) {
            args.add("name=" + name);
        }
    }

    private void addDryRun(CucumberPerfOptions options, List<String> args) {
        if (options.dryRun()) {
            args.add("dryrun");
        }
    }

    private void addTags(CucumberPerfOptions options, List<String> args) {
        for (String tags : options.tags()) {
            args.add("tags=" + tags);
        }
    }

    private void addPlans(CucumberPerfOptions options, List<String> args) {
        if (options != null && options.plans().length != 0) {
            for (String plans : options.plans()) {
                args.add("plans=" + plans);
            }
            this.plansSpecified = true;
        }
    }

    private void addPlugins(CucumberPerfOptions options, List<String> args) {
        for (String plugin : options.plugin()) {
            args.add("plugin=" + plugin);
        }
    }

    private void addDefaultPlanPathIfNoPlanPathIsSpecified(List<String> args, Class<?> clazz) {
        if (!this.plansSpecified) {
            args.add("classpath" + PerfRuntimeOptionsFactory.packagePath(clazz));
        }
    }

    static String packagePath(Class<?> clazz) {
        return PerfRuntimeOptionsFactory.packagePath(PerfRuntimeOptionsFactory.packageName(clazz.getName()));
    }

    static String packagePath(String packageName) {
        return packageName.replace('.', '/');
    }

    static String packageName(String className) {
        return className.substring(0, Math.max(0, className.lastIndexOf(".")));
    }

    private boolean hasSuperClass(Class<?> classWithOptions) {
        return classWithOptions != Object.class;
    }

    private CucumberPerfOptions getOptions(Class<?> clazz) {
        return clazz.getAnnotation(CucumberPerfOptions.class);
    }
}

