/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.runtime.filter;

import cucumber.perf.runtime.PerfRuntimeOptions;
import cucumber.perf.runtime.filter.NamePredicate;
import cucumber.perf.runtime.filter.Predicate;
import cucumber.perf.runtime.filter.TagPredicate;
import gherkin.ast.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class Filters {
    private final List<Predicate> filters = new ArrayList<Predicate>();

    public Filters(PerfRuntimeOptions options) {
        List<Pattern> nameFilters;
        List<String> tagFilters = options.getTagFilters();
        if (!tagFilters.isEmpty()) {
            this.filters.add(new TagPredicate(tagFilters));
        }
        if (!(nameFilters = options.getNameFilters()).isEmpty()) {
            this.filters.add(new NamePredicate(nameFilters));
        }
    }

    public boolean matchesFilters(Node n) {
        for (Predicate filter : this.filters) {
            if (filter.apply(n)) continue;
            return false;
        }
        return true;
    }
}

