/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.runtime.filter;

import cucumber.perf.runtime.filter.Predicate;
import cucumber.perf.runtime.filter.TagExpressionOld;
import cucumber.perf.salad.ast.Plan;
import cucumber.perf.salad.ast.Simulation;
import cucumber.perf.salad.ast.SimulationPeriod;
import gherkin.ast.Node;
import gherkin.ast.Tag;
import gherkin.pickles.PickleLocation;
import gherkin.pickles.PickleTag;
import io.cucumber.tagexpressions.Expression;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class TagPredicate
implements Predicate {
    private final List<Expression> expressions = new ArrayList<Expression>();
    private final List<TagExpressionOld> oldStyleExpressions = new ArrayList<TagExpressionOld>();

    public TagPredicate(List<String> tagExpressions) {
        if (tagExpressions == null) {
            return;
        }
        TagExpressionParser parser = new TagExpressionParser();
        for (String tagExpression : tagExpressions) {
            if (TagExpressionOld.isOldTagExpression(tagExpression)) {
                this.oldStyleExpressions.add(new TagExpressionOld(Arrays.asList(tagExpression)));
                continue;
            }
            this.expressions.add(parser.parse(tagExpression));
        }
    }

    @Override
    public boolean apply(Node n) {
        if (n instanceof Simulation) {
            return this.apply(((Simulation)n).getTags());
        }
        if (n instanceof SimulationPeriod) {
            return this.apply(((SimulationPeriod)n).getTags());
        }
        if (n instanceof Plan) {
            return this.apply(((Plan)n).getTags());
        }
        return false;
    }

    public boolean apply(Collection<Tag> tags) {
        for (TagExpressionOld oldStyleExpression : this.oldStyleExpressions) {
            ArrayList<PickleTag> ptags = new ArrayList<PickleTag>();
            for (Tag tag : tags) {
                PickleTag pt = new PickleTag(new PickleLocation(tag.getLocation().getColumn(), tag.getLocation().getLine()), tag.getName());
                ptags.add(pt);
            }
            if (oldStyleExpression.evaluate(ptags)) continue;
            return false;
        }
        ArrayList<String> ntags = new ArrayList<String>();
        for (Tag tag : tags) {
            ntags.add(tag.getName());
        }
        for (Expression expression : this.expressions) {
            if (expression.evaluate(ntags)) continue;
            return false;
        }
        return true;
    }
}

