/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.runtime.formatter;

import cucumber.perf.api.event.EventHandler;
import cucumber.perf.api.event.EventListener;
import cucumber.perf.api.event.EventPublisher;
import cucumber.perf.api.event.StatisticsFinished;
import cucumber.perf.api.formatter.Statistics;
import cucumber.perf.api.formatter.SummaryPrinter;
import cucumber.perf.api.result.GroupResult;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class DefaultSummaryPrinter
implements SummaryPrinter,
EventListener {
    private final PrintStream out;
    private EventHandler<StatisticsFinished> statsFinishedEventhandler = new EventHandler<StatisticsFinished>(){

        @Override
        public void receive(StatisticsFinished event) {
            DefaultSummaryPrinter.this.print(event.getResult());
        }
    };

    public DefaultSummaryPrinter() {
        this.out = System.out;
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(StatisticsFinished.class, this.statsFinishedEventhandler);
    }

    private void print(Statistics stats) {
        this.out.println();
        this.printStats(stats);
        this.out.println();
    }

    private void printStats(Statistics s) {
        if (s.getSimulation() != null) {
            this.out.println("Simulation: " + s.getSimulation().getName() + " Start: " + s.getSimulation().getStart() + " Stop: " + s.getSimulation().getStop() + " Duration: " + s.getSimulation().getDuration().toString());
        }
        for (Map.Entry<String, GroupResult> entry : s.getAvg().entrySet()) {
            this.out.println("Group: " + entry.getKey() + " Count: " + s.getCnt().get(entry.getKey()).getResultDuration() + " Avg: " + entry.getValue().getResultDuration() / 1000000L + " Min: " + s.getMin().get(entry.getKey()).getResultDuration() / 1000000L + " Max: " + s.getMax().get(entry.getKey()).getResultDuration() / 1000000L);
            for (int sc = 0; sc < entry.getValue().getChildResults().size(); ++sc) {
                this.out.println("\tScenario: " + entry.getValue().getChildResults().get(sc).getName() + " Count: " + s.getCnt().get(entry.getKey()).getChildResults().get(sc).getResultDuration() + " Avg: " + entry.getValue().getChildResults().get(sc).getResultDuration() / 1000000L + " Min: " + s.getMin().get(entry.getKey()).getChildResults().get(sc).getResultDuration() / 1000000L + " Max: " + s.getMax().get(entry.getKey()).getChildResults().get(sc).getResultDuration() / 1000000L);
                for (int stp = 0; stp < entry.getValue().getChildResults().get(sc).getChildResults().size(); ++stp) {
                    if (entry.getValue().getChildResults().get(sc).getChildResults().get(stp).getResultDuration() == null) continue;
                    this.out.println("\t\tStep: " + entry.getValue().getChildResults().get(sc).getChildResults().get(stp).getName() + " Count: " + s.getCnt().get(entry.getKey()).getChildResults().get(sc).getChildResults().get(stp).getResultDuration() + " Avg: " + entry.getValue().getChildResults().get(sc).getChildResults().get(stp).getResultDuration() / 1000000L + " Min: " + s.getMin().get(entry.getKey()).getChildResults().get(sc).getChildResults().get(stp).getResultDuration() / 1000000L + " Max: " + s.getMax().get(entry.getKey()).getChildResults().get(sc).getChildResults().get(stp).getResultDuration() / 1000000L);
                }
            }
        }
        HashMap<String, HashMap<String, Throwable>> errors = s.getErrors();
        if (!errors.isEmpty()) {
            this.out.println("Errors:");
            for (Map.Entry<String, HashMap<String, Throwable>> entry : errors.entrySet()) {
                this.out.println("Feature: " + entry.getKey());
                for (Map.Entry<String, Throwable> sentry : entry.getValue().entrySet()) {
                    this.out.println("Step: " + entry.getKey());
                    sentry.getValue().printStackTrace(this.out);
                }
            }
        }
    }
}

