/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.runtime.formatter;

import cucumber.api.Result;
import cucumber.api.formatter.AnsiEscapes;
import cucumber.api.formatter.ColorAware;
import cucumber.perf.api.PerfGroup;
import cucumber.perf.api.event.ConcurrentEventListener;
import cucumber.perf.api.event.EventHandler;
import cucumber.perf.api.event.EventPublisher;
import cucumber.perf.api.event.GroupFinished;
import cucumber.perf.api.event.GroupStarted;
import cucumber.perf.api.result.GroupResult;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DetailDisplayPrinter
implements ConcurrentEventListener,
ColorAware {
    private final PrintStream out;
    private boolean monochrome;
    private List<PerfGroup> groups = new ArrayList<PerfGroup>();
    private static final Map<Result.Type, AnsiEscapes> ANSI_ESCAPES = new HashMap<Result.Type, AnsiEscapes>(){
        private static final long serialVersionUID = 1630641595685292213L;
        {
            this.put(Result.Type.PASSED, AnsiEscapes.GREEN);
            this.put(Result.Type.UNDEFINED, AnsiEscapes.YELLOW);
            this.put(Result.Type.PENDING, AnsiEscapes.YELLOW);
            this.put(Result.Type.SKIPPED, AnsiEscapes.CYAN);
            this.put(Result.Type.FAILED, AnsiEscapes.RED);
        }
    };
    private EventHandler<GroupStarted> groupStartedEventhandler = new EventHandler<GroupStarted>(){

        @Override
        public void receive(GroupStarted event) {
            DetailDisplayPrinter.this.updatePerfGroup(event.getGroupId(), event.getGroup());
            DetailDisplayPrinter.this.print(event.getGroupId(), null);
        }
    };
    private EventHandler<GroupFinished> groupFinishedEventhandler = new EventHandler<GroupFinished>(){

        @Override
        public void receive(GroupFinished event) {
            DetailDisplayPrinter.this.updatePerfGroup(event.getGroupId(), event.getGroup());
            DetailDisplayPrinter.this.print(event.getGroupId(), event.getResult());
        }
    };

    public DetailDisplayPrinter() {
        this.out = System.out;
    }

    public void setMonochrome(boolean monochrome) {
        this.monochrome = monochrome;
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(GroupStarted.class, this.groupStartedEventhandler);
        publisher.registerHandlerFor(GroupFinished.class, this.groupFinishedEventhandler);
    }

    public void print(int groupId, GroupResult result) {
        Result.Type status = null;
        if (result != null) {
            status = result.getResult().getStatus();
        }
        String line = "";
        int i = 0;
        for (PerfGroup pg : this.groups) {
            if (i > 0) {
                line = line + " | ";
            }
            line = line + this.trimFeature(pg.getText()) + ":" + pg.getRunning() + "-" + pg.getMaxThreads() + ">" + (i == groupId && status != null && !this.monochrome ? ANSI_ESCAPES.get(result.getResult().getStatus()) + "" + pg.getRan() + AnsiEscapes.RESET : Integer.valueOf(pg.getRan()));
            ++i;
        }
        this.out.print(line + "\r");
    }

    private void updatePerfGroup(int groupId, PerfGroup group) {
        if (this.groups.size() <= groupId) {
            this.groups.add(group);
        } else {
            this.groups.set(groupId, group);
        }
    }

    private String trimFeature(String name) {
        if (name.endsWith(".feature")) {
            return name.substring(0, name.length() - 8);
        }
        return name;
    }
}

