/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.runtime.formatter;

import cucumber.api.Result;
import cucumber.perf.api.event.EventHandler;
import cucumber.perf.api.event.EventListener;
import cucumber.perf.api.event.EventPublisher;
import cucumber.perf.api.event.StatisticsFinished;
import cucumber.perf.api.formatter.Statistics;
import cucumber.perf.api.result.GroupResult;
import cucumber.perf.api.result.ScenarioResult;
import cucumber.perf.runtime.formatter.AppendableBuilder;
import cucumber.runtime.CucumberException;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class JUnitFormatter
implements EventListener {
    private AppendableBuilder builder;
    private Writer out;
    private Document doc;
    private Element rootElement = null;
    private TestCase testCase;
    private Element root;
    private EventHandler<StatisticsFinished> statisticsFinishedHandler = new EventHandler<StatisticsFinished>(){

        @Override
        public void receive(StatisticsFinished event) {
            JUnitFormatter.this.process(event.getResult());
        }
    };

    public JUnitFormatter(AppendableBuilder builder) throws IOException {
        this.builder = builder;
        this.reset();
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(StatisticsFinished.class, this.statisticsFinishedHandler);
    }

    private void reset() {
        TestCase.treatConditionallySkippedAsFailure = false;
        TestCase.currentFeatureFile = null;
        TestCase.previousTestCaseName = "";
        TestCase.exampleNumber = 1;
        try {
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.rootElement = this.doc.createElement("testsuite");
            this.doc.appendChild(this.rootElement);
        }
        catch (ParserConfigurationException e) {
            throw new CucumberException("Error while processing unit report", (Throwable)e);
        }
    }

    public void process(Statistics stats) {
        this.reset();
        for (Map.Entry<String, GroupResult> r : stats.getAvg().entrySet()) {
            this.addFeatureResult(r.getValue());
        }
        this.finishReport();
    }

    private void addFeatureResult(GroupResult fresult) {
        for (ScenarioResult res : fresult.getChildResults()) {
            this.addScenarioResult(res);
        }
    }

    private void addScenarioResult(ScenarioResult result) {
        if (TestCase.currentFeatureFile == null || !TestCase.currentFeatureFile.equals(result.getTestCase().getUri())) {
            TestCase.currentFeatureFile = result.getTestCase().getUri();
            TestCase.previousTestCaseName = "";
            TestCase.exampleNumber = 1;
        }
        this.testCase = new TestCase(result);
        this.root = this.testCase.createElement(this.doc);
        this.testCase.writeElement(this.doc, this.root);
        this.rootElement.appendChild(this.root);
        this.increaseAttributeValue(this.rootElement, "tests");
        if (this.testCase.result.getChildResults().isEmpty()) {
            this.testCase.handleEmptyTestCase(this.doc, this.root, this.testCase.result.getResult());
        } else {
            this.testCase.addTestCaseElement(this.doc, this.root, this.testCase.result.getResult());
        }
    }

    private void finishReport() {
        try {
            this.out = this.builder.build();
            this.rootElement.setAttribute("name", JUnitFormatter.class.getName());
            this.rootElement.setAttribute("failures", String.valueOf(this.rootElement.getElementsByTagName("failure").getLength()));
            this.rootElement.setAttribute("skipped", String.valueOf(this.rootElement.getElementsByTagName("skipped").getLength()));
            this.rootElement.setAttribute("time", this.sumTimes(this.rootElement.getElementsByTagName("testcase")));
            if (this.rootElement.getElementsByTagName("testcase").getLength() == 0) {
                this.addDummyTestCase();
            }
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(this.out);
            DOMSource source = new DOMSource(this.doc);
            trans.transform(source, result);
            JUnitFormatter.closeQuietly(this.out);
        }
        catch (TransformerException e) {
            throw new CucumberException("Error while transforming.", (Throwable)e);
        }
    }

    private void addDummyTestCase() {
        Element dummy = this.doc.createElement("testcase");
        dummy.setAttribute("classname", "dummy");
        dummy.setAttribute("name", "dummy");
        this.rootElement.appendChild(dummy);
        Element skipped = this.doc.createElement("skipped");
        skipped.setAttribute("message", "No features found");
        dummy.appendChild(skipped);
    }

    private String sumTimes(NodeList testCaseNodes) {
        double totalDurationSecondsForAllTimes = 0.0;
        for (int i = 0; i < testCaseNodes.getLength(); ++i) {
            try {
                double testCaseTime = Double.parseDouble(testCaseNodes.item(i).getAttributes().getNamedItem("time").getNodeValue());
                totalDurationSecondsForAllTimes += testCaseTime;
                continue;
            }
            catch (NumberFormatException e) {
                throw new CucumberException((Throwable)e);
            }
            catch (NullPointerException e) {
                throw new CucumberException((Throwable)e);
            }
        }
        DecimalFormat nfmt = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        nfmt.applyPattern("0.######");
        return nfmt.format(totalDurationSecondsForAllTimes);
    }

    private void increaseAttributeValue(Element element, String attribute) {
        int value = 0;
        if (element.hasAttribute(attribute)) {
            value = Integer.parseInt(element.getAttribute(attribute));
        }
        element.setAttribute(attribute, String.valueOf(++value));
    }

    private static void closeQuietly(Closeable out) {
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class TestCase {
        private static final DecimalFormat NUMBER_FORMAT = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        static String currentFeatureFile;
        static String previousTestCaseName;
        static int exampleNumber;
        static boolean treatConditionallySkippedAsFailure;
        private final ScenarioResult result;

        private TestCase(ScenarioResult result) {
            this.result = result;
        }

        private Element createElement(Document doc) {
            return doc.createElement("testcase");
        }

        private void writeElement(Document doc, Element tc) {
            tc.setAttribute("name", this.calculateElementName(this.result.getName()));
        }

        private String calculateElementName(String name) {
            String testCaseName = name;
            if (testCaseName.equals(previousTestCaseName)) {
                return testCaseName + (this.includesBlank(testCaseName) ? " " : "_") + ++exampleNumber;
            }
            previousTestCaseName = name;
            exampleNumber = 1;
            return testCaseName;
        }

        private boolean includesBlank(String testCaseName) {
            return testCaseName.indexOf(32) != -1;
        }

        public void addTestCaseElement(Document doc, Element tc, Result result) {
            Element child;
            tc.setAttribute("time", this.calculateTotalDurationString(result));
            StringBuilder sb = new StringBuilder();
            this.addStepAndResultListing(sb);
            if (result.is(Result.Type.FAILED)) {
                this.addStackTrace(sb, result);
                child = this.createElementWithMessage(doc, sb, "failure", result.getErrorMessage());
            } else if (result.is(Result.Type.AMBIGUOUS)) {
                this.addStackTrace(sb, result);
                child = this.createElementWithMessage(doc, sb, "failure", result.getErrorMessage());
            } else if (result.is(Result.Type.PENDING) || result.is(Result.Type.UNDEFINED)) {
                child = treatConditionallySkippedAsFailure ? this.createElementWithMessage(doc, sb, "failure", "The scenario has pending or undefined step(s)") : this.createElement(doc, sb, "skipped");
            } else if (result.is(Result.Type.SKIPPED) && result.getError() != null) {
                this.addStackTrace(sb, result);
                child = this.createElementWithMessage(doc, sb, "skipped", result.getErrorMessage());
            } else {
                child = this.createElement(doc, sb, "system-out");
            }
            tc.appendChild(child);
        }

        public void handleEmptyTestCase(Document doc, Element tc, Result result) {
            tc.setAttribute("time", this.calculateTotalDurationString(result));
            String resultType = treatConditionallySkippedAsFailure ? "failure" : "skipped";
            Element child = this.createElementWithMessage(doc, new StringBuilder(), resultType, "The scenario has no steps");
            tc.appendChild(child);
        }

        private String calculateTotalDurationString(Result result) {
            return NUMBER_FORMAT.format((double)result.getDuration().longValue() / 1.0E9);
        }

        private void addStepAndResultListing(StringBuilder sb) {
            for (int i = 0; i < this.result.getChildResults().size(); ++i) {
                int length = sb.length();
                String resultStatus = "not executed";
                if (i < this.result.getChildResults().size()) {
                    resultStatus = this.result.getChildResults().get(i).getResult().getStatus().lowerCaseName();
                }
                sb.append(this.result.getChildResults().get(i).getName());
                do {
                    sb.append(".");
                } while (sb.length() - length < 76);
                sb.append(resultStatus);
                sb.append("\n");
            }
        }

        private void addStackTrace(StringBuilder sb, Result failed) {
            sb.append("\nStackTrace:\n");
            StringWriter sw = new StringWriter();
            failed.getError().printStackTrace(new PrintWriter(sw));
            sb.append(sw.toString());
        }

        private Element createElementWithMessage(Document doc, StringBuilder sb, String elementType, String message) {
            Element child = this.createElement(doc, sb, elementType);
            child.setAttribute("message", message);
            return child;
        }

        private Element createElement(Document doc, StringBuilder sb, String elementType) {
            Element child = doc.createElement(elementType);
            String systemLineSeperator = System.getProperty("line.separator");
            child.appendChild(doc.createCDATASection(sb.toString().replace(systemLineSeperator, "\n")));
            return child;
        }

        static {
            NUMBER_FORMAT.applyPattern("0.######");
            treatConditionallySkippedAsFailure = false;
        }
    }
}

