/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.runtime.formatter;

import cucumber.api.Result;
import cucumber.api.formatter.NiceAppendable;
import cucumber.perf.api.PerfGroup;
import cucumber.perf.api.event.EventBus;
import cucumber.perf.api.event.EventHandler;
import cucumber.perf.api.event.EventListener;
import cucumber.perf.api.event.EventPublisher;
import cucumber.perf.api.event.GroupFinished;
import cucumber.perf.api.event.PerfRunStarted;
import cucumber.perf.api.event.SimulationFinished;
import cucumber.perf.api.event.SimulationStarted;
import cucumber.perf.api.formatter.EventWriter;
import cucumber.perf.api.result.BaseResult;
import cucumber.perf.api.result.GroupResult;
import cucumber.perf.api.result.ScenarioResult;
import cucumber.perf.api.result.SimulationResult;
import cucumber.perf.api.result.StepResult;
import cucumber.perf.api.result.TestCase;
import cucumber.perf.runtime.formatter.AppendableBuilder;
import cucumber.perf.runtime.formatter.URLInputStream;
import cucumber.perf.runtime.formatter.UTF8InputStreamReader;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Utils;
import gherkin.deps.com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LoggerFormatter
implements EventListener,
EventWriter {
    private NiceAppendable out;
    private AppendableBuilder builder;
    private String filePath = null;
    private EventBus eventBus = null;
    private EventHandler<GroupFinished> groupFinishedEventhandler = new EventHandler<GroupFinished>(){

        @Override
        public void receive(GroupFinished event) {
            LoggerFormatter.this.log(event.getGroup(), event.getResult());
        }
    };
    private EventHandler<SimulationStarted> simStartedEventhandler = new EventHandler<SimulationStarted>(){

        @Override
        public void receive(SimulationStarted event) {
            LoggerFormatter.this.reset(event.getName());
        }
    };
    private EventHandler<SimulationFinished> simFinishedEventhandler = new EventHandler<SimulationFinished>(){

        @Override
        public void receive(SimulationFinished event) {
            LoggerFormatter.this.finish();
        }
    };
    private EventHandler<PerfRunStarted> perfRunStartedEventHandler = new EventHandler<PerfRunStarted>(){

        @Override
        public void receive(PerfRunStarted event) {
            LoggerFormatter.this.processFile();
        }
    };

    public LoggerFormatter(AppendableBuilder builder) {
        this.builder = builder;
    }

    public LoggerFormatter(AppendableBuilder builder, String[] options) {
        this.builder = builder;
        if (options != null && options[0].length() > 0) {
            this.filePath = options[0];
        }
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(GroupFinished.class, this.groupFinishedEventhandler);
        publisher.registerHandlerFor(SimulationStarted.class, this.simStartedEventhandler);
        publisher.registerHandlerFor(SimulationFinished.class, this.simFinishedEventhandler);
        publisher.registerHandlerFor(PerfRunStarted.class, this.perfRunStartedEventHandler);
    }

    @Override
    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    private void log(PerfGroup group, GroupResult result) {
        Gson gson = new Gson();
        String json = gson.toJson((Object)result);
        this.out.println((CharSequence)",");
        this.out.append((CharSequence)json);
    }

    private void finish() {
        try {
            this.out.append(']');
            this.out.close();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void reset(String name) {
        this.out = new NiceAppendable((Appendable)this.builder.build());
        this.out.println((CharSequence)"[");
        this.out.append((CharSequence)("{\"simulation\": " + name + "}"));
    }

    private void processFile() {
        String fc;
        if (this.filePath != null && !(fc = LoggerFormatter.loadFromUrl(Utils.toURL((String)this.filePath))).isEmpty()) {
            if (!fc.endsWith("]")) {
                fc = fc + ']';
            }
            Gson gson = new Gson();
            List json = (List)gson.fromJson(fc, new ArrayList().getClass());
            this.eventBus.send(new SimulationFinished(this.eventBus.getTime(), this.eventBus.getTimeMillis(), this.createSimulationResult(json)));
        }
    }

    public SimulationResult createSimulationResult(List<Map<String, Object>> mapList) {
        Map<String, Object> sim = mapList.remove(0);
        Gson gson = new Gson();
        String name = (String)sim.get("simulation");
        LocalDateTime start = (LocalDateTime)gson.fromJson(gson.toJson(mapList.get(0).get("start")), LocalDateTime.class);
        LocalDateTime stop = (LocalDateTime)gson.fromJson(gson.toJson(mapList.get(mapList.size() - 1).get("stop")), LocalDateTime.class);
        return new SimulationResult(name, new Result(Result.Type.PASSED, Long.valueOf(stop.toInstant(ZoneOffset.UTC).getEpochSecond() - start.toInstant(ZoneOffset.UTC).getEpochSecond()), null), start, stop, this.createGroupResultList(mapList));
    }

    public List<GroupResult> createGroupResultList(List<Map<String, Object>> mapList) {
        ArrayList<GroupResult> result = new ArrayList<GroupResult>();
        for (Map<String, Object> map : mapList) {
            result.add(this.createGroupResult(map));
        }
        return result;
    }

    private GroupResult createGroupResult(Map<String, Object> map) {
        BaseResult br = this.createBaseResult(map);
        GroupResult result = new GroupResult(br.getName(), br.getResult(), br.getStart(), br.getStop());
        for (Map m : (List)map.get("childResults")) {
            result.addChildResult(this.createScenarioResult(m));
        }
        return result;
    }

    private BaseResult createBaseResult(Map<String, Object> map) {
        Result result = this.createResult((Map)map.get("result"));
        Gson gson = new Gson();
        LocalDateTime start = (LocalDateTime)gson.fromJson(gson.toJson(map.get("start")), LocalDateTime.class);
        LocalDateTime stop = (LocalDateTime)gson.fromJson(gson.toJson(map.get("stop")), LocalDateTime.class);
        return new BaseResult((String)map.get("name"), result, start, stop);
    }

    private ScenarioResult createScenarioResult(Map<String, Object> map) {
        Gson gson = new Gson();
        BaseResult br = this.createBaseResult(map);
        Map tcm = (Map)map.get("testCase");
        List tags = (List)gson.fromJson(gson.toJson(tcm.get("tags")), new ArrayList().getClass());
        List testSteps = (List)gson.fromJson(gson.toJson(tcm.get("testSteps")), new ArrayList().getClass());
        TestCase tc = new TestCase((int)((Double)tcm.get("line")).doubleValue(), (String)tcm.get("uri"), (String)tcm.get("name"), (String)tcm.get("scenarioDesignation"), tags, testSteps);
        ScenarioResult result = new ScenarioResult(br.getName(), tc, br.getResult(), br.getStart(), br.getStop());
        for (Map m : (List)map.get("childResults")) {
            result.addChildResult(this.createStepResult(m));
        }
        return result;
    }

    private StepResult createStepResult(Map<String, Object> map) {
        Gson gson = new Gson();
        return (StepResult)gson.fromJson(gson.toJson(map), StepResult.class);
    }

    private Result createResult(Map<String, Object> map) {
        Gson gson = new Gson();
        return (Result)gson.fromJson(gson.toJson(map), Result.class);
    }

    private static String loadFromUrl(URL url) {
        String result = "";
        InputStreamReader in = LoggerFormatter.getInputStream(url);
        try (BufferedReader br = new BufferedReader(in);){
            String nextLine;
            while ((nextLine = br.readLine()) != null) {
                result = result + nextLine;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LoggerFormatter.closeQuietly(in);
        return result;
    }

    private static InputStreamReader getInputStream(URL url) {
        try {
            return new UTF8InputStreamReader(new URLInputStream(url));
        }
        catch (MalformedURLException e) {
            throw new CucumberException((Throwable)e);
        }
        catch (IOException e) {
            throw new CucumberException((Throwable)e);
        }
    }

    private static void closeQuietly(Closeable in) {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

