/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.runtime.formatter;

import cucumber.api.Plugin;
import cucumber.perf.api.event.ConcurrentEventListener;
import cucumber.perf.api.event.EventListener;
import cucumber.perf.api.formatter.DisplayPrinter;
import cucumber.perf.api.formatter.SummaryPrinter;
import cucumber.perf.runtime.formatter.AppendableBuilder;
import cucumber.perf.runtime.formatter.ChartPointsFormatter;
import cucumber.perf.runtime.formatter.DefaultSummaryPrinter;
import cucumber.perf.runtime.formatter.DetailDisplayPrinter;
import cucumber.perf.runtime.formatter.JUnitFormatter;
import cucumber.perf.runtime.formatter.LoggerFormatter;
import cucumber.perf.runtime.formatter.NullDisplayPrinter;
import cucumber.perf.runtime.formatter.NullSummaryPrinter;
import cucumber.perf.runtime.formatter.StatisticsFormatter;
import cucumber.perf.runtime.formatter.SummaryTextFormatter;
import cucumber.perf.runtime.formatter.URLOutputStream;
import cucumber.perf.runtime.formatter.UTF8OutputStreamWriter;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Utils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PluginFactory {
    private final Class[] CTOR_PARAMETERS = new Class[]{String.class, Appendable.class, AppendableBuilder.class, URI.class, URL.class, File.class};
    private static final HashMap<String, Class<? extends Plugin>> PLUGIN_CLASSES = new HashMap<String, Class<? extends Plugin>>(){
        {
            this.put("junit", JUnitFormatter.class);
            this.put("chart_points", ChartPointsFormatter.class);
            this.put("summary_text", SummaryTextFormatter.class);
            this.put("logger", LoggerFormatter.class);
            this.put("statistics", StatisticsFormatter.class);
            this.put("default_summary", DefaultSummaryPrinter.class);
            this.put("null_summary", NullSummaryPrinter.class);
            this.put("null_display", NullDisplayPrinter.class);
            this.put("detail_display", DetailDisplayPrinter.class);
        }
    };
    private static final Pattern PLUGIN_WITH_ARG_PATTERN = Pattern.compile("([^:]+):(.*)");
    private static final Pattern PLUGIN_WITH_ARG_AND_OPTS_PATTERN = Pattern.compile("([^:]*)(?::)(.*)(?::(?![\\/]))([^:]*)");
    private String defaultOutFormatter = null;
    private Appendable defaultOut = new PrintStream(System.out){

        @Override
        public void close() {
        }
    };

    public Plugin create(String pluginString) {
        String options;
        String argument;
        String pluginName;
        Matcher pluginWithArg = PLUGIN_WITH_ARG_PATTERN.matcher(pluginString);
        Matcher pluginWithArgOpts = PLUGIN_WITH_ARG_AND_OPTS_PATTERN.matcher(pluginString);
        if (pluginWithArgOpts.matches()) {
            pluginName = pluginWithArgOpts.group(1);
            argument = pluginWithArgOpts.group(2);
            String string = pluginWithArgOpts.group(3);
        }
        if (pluginWithArg.matches()) {
            pluginName = pluginWithArg.group(1);
            argument = pluginWithArg.group(2);
            options = null;
        } else {
            pluginName = pluginString;
            argument = null;
            options = null;
        }
        Class<? extends Plugin> pluginClass = PluginFactory.pluginClass(pluginName);
        try {
            return this.instantiate(pluginString, pluginClass, argument, options);
        }
        catch (IOException e) {
            throw new CucumberException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new CucumberException((Throwable)e);
        }
    }

    private <T extends Plugin> T instantiate(String pluginString, Class<T> pluginClass, String argument, String options) throws IOException, URISyntaxException {
        Object ctorArg;
        String[] stringArray;
        Constructor<T> twoarg = this.findDoubleArgConstructor(pluginClass);
        Constructor<T> singlearg = this.findSingleArgConstructor(pluginClass);
        Constructor<T> empty = this.findEmptyConstructor(pluginClass);
        if (options == null) {
            stringArray = new String[]{};
        } else if (options.contains(",")) {
            stringArray = options.split(",");
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = options;
        }
        String[] opts = stringArray;
        if (twoarg != null && (ctorArg = this.convertOrNull(argument, twoarg.getParameterTypes()[0], pluginString)) != null) {
            return this.newInstance(twoarg, ctorArg, opts);
        }
        if (singlearg != null && (ctorArg = this.convertOrNull(argument, singlearg.getParameterTypes()[0], pluginString)) != null) {
            return this.newInstance(singlearg, ctorArg);
        }
        if (argument == null && empty != null) {
            return this.newInstance(empty, new Object[0]);
        }
        if (twoarg != null) {
            throw new CucumberException(String.format("You must supply an output argument to %s. Like so: %s:output", pluginString, pluginString));
        }
        throw new CucumberException(String.format("%s must have a constructor that is either empty or a double arg of one of: %s, String[]", pluginClass, Arrays.asList(this.CTOR_PARAMETERS)));
    }

    private <T extends Plugin> T newInstance(Constructor<T> constructor, Object ... ctorArgs) {
        try {
            return (T)((Plugin)constructor.newInstance(ctorArgs));
        }
        catch (InstantiationException e) {
            throw new CucumberException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CucumberException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new CucumberException(e.getTargetException());
        }
    }

    private Object convertOrNull(String arg, Class<?> ctorArgClass, String formatterString) throws IOException, URISyntaxException {
        if (arg == null) {
            if (ctorArgClass.equals(Appendable.class)) {
                return this.defaultOutOrFailIfAlreadyUsed(formatterString);
            }
            return null;
        }
        if (ctorArgClass.equals(URI.class)) {
            return new URI(arg);
        }
        if (ctorArgClass.equals(URL.class)) {
            return Utils.toURL((String)arg);
        }
        if (ctorArgClass.equals(File.class)) {
            return new File(arg);
        }
        if (ctorArgClass.equals(String.class)) {
            return arg;
        }
        if (ctorArgClass.equals(Appendable.class)) {
            return new UTF8OutputStreamWriter(new URLOutputStream(Utils.toURL((String)arg)));
        }
        if (ctorArgClass.equals(AppendableBuilder.class)) {
            return new AppendableBuilder(arg);
        }
        return null;
    }

    private <T> Constructor<T> findDoubleArgConstructor(Class<T> pluginClass) {
        Constructor<T> constructor = null;
        for (Class ctorArgClass : this.CTOR_PARAMETERS) {
            try {
                Constructor<T> candidate = pluginClass.getConstructor(ctorArgClass, String[].class);
                if (constructor != null) {
                    throw new CucumberException(String.format("Plugin %s should only define a single two-argument constructor", pluginClass.getName()));
                }
                constructor = candidate;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return constructor;
    }

    private <T> Constructor<T> findSingleArgConstructor(Class<T> pluginClass) {
        Constructor<T> constructor = null;
        for (Class ctorArgClass : this.CTOR_PARAMETERS) {
            try {
                Constructor<T> candidate = pluginClass.getConstructor(ctorArgClass);
                if (constructor != null) {
                    throw new CucumberException(String.format("Plugin %s should only define a single one-argument constructor", pluginClass.getName()));
                }
                constructor = candidate;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return constructor;
    }

    private <T> Constructor<T> findEmptyConstructor(Class<T> pluginClass) {
        try {
            return pluginClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
    }

    private static Class<? extends Plugin> pluginClass(String pluginName) {
        Class<? extends Plugin> pluginClass = PLUGIN_CLASSES.get(pluginName);
        if (pluginClass == null) {
            pluginClass = PluginFactory.loadClass(pluginName);
        }
        return pluginClass;
    }

    private static Class<? extends Plugin> loadClass(String className) {
        try {
            Class<?> aClass = Thread.currentThread().getContextClassLoader().loadClass(className);
            if (Plugin.class.isAssignableFrom(aClass)) {
                return aClass;
            }
            throw new CucumberException("Couldn't load plugin class: " + className + ". It does not implement " + Plugin.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new CucumberException("Couldn't load plugin class: " + className, (Throwable)e);
        }
    }

    private Appendable defaultOutOrFailIfAlreadyUsed(String formatterString) {
        try {
            if (this.defaultOut != null) {
                this.defaultOutFormatter = formatterString;
                Appendable appendable = this.defaultOut;
                return appendable;
            }
            throw new CucumberException("Only one formatter can use STDOUT, now both " + this.defaultOutFormatter + " and " + formatterString + " use it. If you use more than one formatter you must specify output path with PLUGIN:PATH_OR_URL");
        }
        finally {
            this.defaultOut = null;
        }
    }

    public static boolean isFormatterName(String name) {
        Class<?> pluginClass = PluginFactory.getPluginClass(name);
        return EventListener.class.isAssignableFrom(pluginClass) || ConcurrentEventListener.class.isAssignableFrom(pluginClass);
    }

    public static boolean isSummaryPrinterName(String name) {
        Class<?> pluginClass = PluginFactory.getPluginClass(name);
        return SummaryPrinter.class.isAssignableFrom(pluginClass);
    }

    public static boolean isDisplayName(String name) {
        Class<?> pluginClass = PluginFactory.getPluginClass(name);
        return DisplayPrinter.class.isAssignableFrom(pluginClass);
    }

    private static Class<?> getPluginClass(String name) {
        Matcher pluginWithArg = PLUGIN_WITH_ARG_PATTERN.matcher(name);
        Matcher pluginWithArgOpts = PLUGIN_WITH_ARG_AND_OPTS_PATTERN.matcher(name);
        if (pluginWithArgOpts.matches()) {
            String string = pluginWithArgOpts.group(1);
        }
        String pluginName = pluginWithArg.matches() ? pluginWithArg.group(1) : name;
        return PluginFactory.pluginClass(pluginName);
    }
}

