/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.runtime.formatter;

import cucumber.api.Plugin;
import cucumber.api.formatter.ColorAware;
import cucumber.api.formatter.StrictAware;
import cucumber.perf.api.event.ConcurrentEventListener;
import cucumber.perf.api.event.EventBus;
import cucumber.perf.api.event.EventListener;
import cucumber.perf.api.formatter.EventWriter;
import cucumber.perf.runtime.PerfRuntimeOptions;
import cucumber.perf.runtime.formatter.PluginFactory;
import cucumber.runtime.Utils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

public final class Plugins {
    private final List<Plugin> plugins;
    private final ClassLoader classLoader;
    private boolean pluginNamesInstantiated;
    private final PluginFactory pluginFactory;
    private final PerfRuntimeOptions pluginOptions;

    public Plugins(ClassLoader classLoader, PluginFactory pluginFactory, PerfRuntimeOptions pluginOptions) {
        this.classLoader = classLoader;
        this.pluginFactory = pluginFactory;
        this.pluginOptions = pluginOptions;
        this.plugins = this.createPlugins();
    }

    private List<Plugin> createPlugins() {
        ArrayList<Plugin> plugins = new ArrayList<Plugin>();
        if (!this.pluginNamesInstantiated) {
            for (String pluginName : this.pluginOptions.getPluginsNames()) {
                Plugin plugin = this.pluginFactory.create(pluginName);
                this.addPlugin(plugins, plugin);
            }
            this.pluginNamesInstantiated = true;
        }
        return plugins;
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public void addPlugin(Plugin plugin) {
        this.addPlugin(this.plugins, plugin);
    }

    private void addPlugin(List<Plugin> plugins, Plugin plugin) {
        plugins.add(plugin);
        this.setMonochromeOnColorAwarePlugins(plugin);
        this.setStrictOnStrictAwarePlugins(plugin);
    }

    private void setMonochromeOnColorAwarePlugins(Plugin plugin) {
        if (plugin instanceof ColorAware) {
            ColorAware colorAware = (ColorAware)plugin;
            colorAware.setMonochrome(this.pluginOptions.isMonochrome());
        }
    }

    private void setStrictOnStrictAwarePlugins(Plugin plugin) {
        if (plugin instanceof StrictAware) {
            StrictAware strictAware = (StrictAware)plugin;
            strictAware.setStrict(this.pluginOptions.isStrict());
        }
    }

    public void setEventBusOnPlugins(EventBus eventBus) {
        for (Plugin plugin : this.plugins) {
            if (plugin instanceof ConcurrentEventListener) {
                ((ConcurrentEventListener)plugin).setEventPublisher(eventBus);
            } else if (plugin instanceof EventListener) {
                ((EventListener)plugin).setEventPublisher(eventBus);
            }
            if (!(plugin instanceof EventWriter)) continue;
            ((EventWriter)plugin).setEventBus(eventBus);
        }
    }

    private <T> T pluginProxy(final Class<T> type) {
        Object proxy = Proxy.newProxyInstance(this.classLoader, new Class[]{type}, new InvocationHandler(){

            @Override
            public Object invoke(Object target, Method method, Object[] args) throws Throwable {
                for (Plugin plugin : Plugins.this.getPlugins()) {
                    if (!type.isInstance(plugin)) continue;
                    try {
                        Utils.invoke((Object)plugin, (Method)method, (long)0L, (Object[])args);
                    }
                    catch (Throwable t) {
                        if (method.getName().equals("startOfScenarioLifeCycle") || method.getName().equals("endOfScenarioLifeCycle")) continue;
                        throw t;
                    }
                }
                return null;
            }
        });
        return type.cast(proxy);
    }
}

