/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.runtime.formatter;

import cucumber.api.Result;
import cucumber.api.formatter.StrictAware;
import cucumber.perf.api.event.ConfigStatistics;
import cucumber.perf.api.event.EventBus;
import cucumber.perf.api.event.EventHandler;
import cucumber.perf.api.event.EventListener;
import cucumber.perf.api.event.EventPublisher;
import cucumber.perf.api.event.SimulationFinished;
import cucumber.perf.api.event.StatisticsFinished;
import cucumber.perf.api.event.StatisticsStarted;
import cucumber.perf.api.formatter.EventWriter;
import cucumber.perf.api.formatter.Statistics;
import cucumber.perf.api.result.BaseResult;
import cucumber.perf.api.result.GroupResult;
import cucumber.perf.api.result.ScenarioResult;
import cucumber.perf.api.result.SimulationResult;
import cucumber.perf.api.result.StepResult;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StatisticsFormatter
implements EventListener,
EventWriter,
StrictAware {
    private int maxPoints = 20;
    public static final String CONFIG_MAXPOINTS = "maxPoints";
    private Statistics stats;
    private HashMap<String, List<GroupResult>> results = new HashMap();
    private boolean isStrict = true;
    private EventBus eventBus = null;
    private EventPublisher publisher = null;
    private EventHandler<SimulationFinished> simulationFinishedHandler = new EventHandler<SimulationFinished>(){

        @Override
        public void receive(SimulationFinished event) {
            StatisticsFormatter.this.process(event.getResult());
        }
    };
    private EventHandler<ConfigStatistics> configStatisticsHandler = new EventHandler<ConfigStatistics>(){

        @Override
        public void receive(ConfigStatistics event) {
            StatisticsFormatter.this.config(event.setting, event.value);
        }
    };

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        this.publisher = publisher;
        publisher.registerHandlerFor(SimulationFinished.class, this.simulationFinishedHandler);
        publisher.registerHandlerFor(ConfigStatistics.class, this.configStatisticsHandler);
    }

    @Override
    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void setStrict(boolean strict) {
        this.isStrict = strict;
    }

    private void config(String setting, Object value) {
        if (setting == CONFIG_MAXPOINTS) {
            this.maxPoints = (Integer)value;
        }
    }

    private void process(SimulationResult result) {
        this.stats = new Statistics();
        if (result != null) {
            this.stats.setSimulation(new BaseResult(result.getName(), result.getResult(), result.getStart(), result.getStop()));
            if (result.getChildResults() != null && !result.getChildResults().isEmpty()) {
                this.eventBus.send(new StatisticsStarted(this.eventBus.getTime(), (long)this.eventBus.getTimeMillis()));
                for (GroupResult o : result.getChildResults()) {
                    if (this.results.containsKey(o.getName())) {
                        this.results.get(o.getName()).add(o);
                        continue;
                    }
                    this.results.put(o.getName(), new ArrayList<GroupResult>(Arrays.asList(o)));
                }
                this.calculate(this.isStrict);
                this.stats.setErrors(this.getErrors());
                this.eventBus.send(new StatisticsFinished(this.eventBus.getTime(), this.eventBus.getTimeMillis(), this.stats));
            }
        }
    }

    private void calculate(boolean isStrict) {
        for (Map.Entry<String, List<GroupResult>> entry : this.results.entrySet()) {
            int sci;
            ArrayList l = new ArrayList();
            l.add(new HashMap());
            this.stats.getChartPoints().put(entry.getKey(), l);
            LocalDateTime startPeriod = entry.getValue().get(0).getStart();
            Long period = this.getPeriod(Duration.between(entry.getValue().get(0).getStart(), entry.getValue().get(entry.getValue().size() - 1).getStart()), this.maxPoints);
            LocalDateTime nextPeriod = this.getEnd(startPeriod, period);
            GroupResult pointMin = new GroupResult(entry.getValue().get(0));
            GroupResult pointMax = new GroupResult(entry.getValue().get(0));
            GroupResult pointSum = new GroupResult(entry.getValue().get(0));
            GroupResult sum = new GroupResult(entry.getValue().get(0));
            GroupResult min = new GroupResult(entry.getValue().get(0));
            GroupResult max = new GroupResult(entry.getValue().get(0));
            boolean first = true;
            int count = 0;
            for (GroupResult f : entry.getValue()) {
                if (!first) {
                    int sti;
                    if (f.getStop().isAfter(nextPeriod)) {
                        GroupResult pointAvg = new GroupResult(pointSum);
                        pointAvg.setResult(new Result(pointAvg.getResult().getStatus(), Long.valueOf(count > 0 ? pointAvg.getResultDuration() / (long)count : pointAvg.getResultDuration()), pointAvg.getResult().getError()));
                        for (int sci2 = 0; sci2 < pointAvg.getChildResults().size(); ++sci2) {
                            pointAvg.getChildResults().get(sci2).setResult(new Result(pointSum.getChildResults().get(sci2).getResult().getStatus(), Long.valueOf(count > 0 ? pointSum.getChildResults().get(sci2).getResultDuration() / (long)count : pointSum.getChildResults().get(sci2).getResultDuration()), pointAvg.getChildResults().get(sci2).getResult().getError()));
                            for (sti = 0; sti < pointAvg.getChildResults().get(sci2).getChildResults().size(); ++sti) {
                                if (pointAvg.getChildResults().get(sci2).getChildResults().get(sti).getResult().getDuration() == null) continue;
                                pointAvg.getChildResults().get(sci2).getChildResults().get(sti).setResult(new Result(pointAvg.getChildResults().get(sci2).getChildResults().get(sti).getResult().getStatus(), Long.valueOf(count > 0 ? pointAvg.getChildResults().get(sci2).getChildResults().get(sti).getResultDuration() / (long)count : pointAvg.getChildResults().get(sci2).getChildResults().get(sti).getResultDuration()), pointAvg.getChildResults().get(sci2).getChildResults().get(sti).getResult().getError()));
                            }
                        }
                        this.stats.getChartPoints().get(entry.getKey()).get(this.stats.getChartPoints().get(entry.getKey()).size() - 1).put("avg", pointAvg);
                        this.stats.getChartPoints().get(entry.getKey()).get(this.stats.getChartPoints().get(entry.getKey()).size() - 1).put("min", pointMin);
                        this.stats.getChartPoints().get(entry.getKey()).get(this.stats.getChartPoints().get(entry.getKey()).size() - 1).put("max", pointMax);
                        nextPeriod = this.getEnd(nextPeriod, period);
                        pointMin = new GroupResult(f);
                        pointMax = new GroupResult(f);
                        pointSum = new GroupResult(f);
                        this.stats.getChartPoints().get(entry.getKey()).add(new HashMap());
                        count = 0;
                    }
                    ++count;
                    if (isStrict && f.getResult().isOk(isStrict) || !isStrict) {
                        sum.setResult(new Result(f.getResult().getStatus(), Long.valueOf(sum.getResultDuration() + f.getResultDuration()), f.getResult().getError()));
                        pointSum.setResult(new Result(f.getResult().getStatus(), Long.valueOf(count > 1 ? pointSum.getResultDuration() + f.getResultDuration() : f.getResultDuration()), f.getResult().getError()));
                        if (f.getResultDuration() > max.getResultDuration()) {
                            max.setResult(new Result(f.getResult().getStatus(), f.getResultDuration(), f.getResult().getError()));
                            pointMax.setResult(new Result(f.getResult().getStatus(), f.getResultDuration(), f.getResult().getError()));
                        } else if (f.getResultDuration() < min.getResultDuration()) {
                            min.setResult(new Result(f.getResult().getStatus(), f.getResultDuration(), f.getResult().getError()));
                            pointMin.setResult(new Result(f.getResult().getStatus(), f.getResultDuration(), f.getResult().getError()));
                        }
                    }
                    for (sci = 0; sci < f.getChildResults().size(); ++sci) {
                        ScenarioResult sc = f.getChildResults().get(sci);
                        if (isStrict && sc.getResult().isOk(isStrict) || !isStrict) {
                            try {
                                sum.getChildResults().get(sci).setResult(new Result(sc.getResult().getStatus(), Long.valueOf(sum.getChildResults().get(sci).getResultDuration() + sc.getResultDuration()), sc.getResult().getError()));
                                pointSum.getChildResults().get(sci).setResult(new Result(sc.getResult().getStatus(), Long.valueOf(count > 1 ? pointSum.getChildResults().get(sci).getResultDuration() + sc.getResultDuration() : sc.getResultDuration()), sc.getResult().getError()));
                                if (sc.getResultDuration() > max.getChildResults().get(sci).getResultDuration()) {
                                    max.getChildResults().get(sci).setResult(new Result(sc.getResult().getStatus(), sc.getResultDuration(), sc.getResult().getError()));
                                    pointMax.getChildResults().get(sci).setResult(new Result(sc.getResult().getStatus(), sc.getResultDuration(), sc.getResult().getError()));
                                } else if (sc.getResultDuration() < min.getChildResults().get(sci).getResultDuration()) {
                                    min.getChildResults().get(sci).setResult(new Result(sc.getResult().getStatus(), sc.getResultDuration(), sc.getResult().getError()));
                                    pointMin.getChildResults().get(sci).setResult(new Result(sc.getResult().getStatus(), sc.getResultDuration(), sc.getResult().getError()));
                                }
                            }
                            catch (Exception sti2) {
                                // empty catch block
                            }
                        }
                        for (sti = 0; sti < sc.getChildResults().size(); ++sti) {
                            try {
                                StepResult stp = sc.getChildResults().get(sti);
                                if (sum.getChildResults().get(sci).getChildResults().get(sti).getResultDuration() != null && (isStrict && stp.getResult().isOk(isStrict) || !isStrict)) {
                                    sum.getChildResults().get(sci).getChildResults().get(sti).setResult(new Result(stp.getResult().getStatus(), Long.valueOf(sum.getChildResults().get(sci).getChildResults().get(sti).getResultDuration() + stp.getResultDuration()), stp.getResult().getError()));
                                    pointSum.getChildResults().get(sci).getChildResults().get(sti).setResult(new Result(stp.getResult().getStatus(), Long.valueOf(count > 1 ? pointSum.getChildResults().get(sci).getChildResults().get(sti).getResultDuration() + stp.getResultDuration() : stp.getResultDuration()), stp.getResult().getError()));
                                }
                                if (stp.getResultDuration() != null && stp.getResultDuration() > max.getChildResults().get(sci).getChildResults().get(sti).getResultDuration()) {
                                    max.getChildResults().get(sci).getChildResults().get(sti).setResult(new Result(stp.getResult().getStatus(), stp.getResultDuration(), stp.getResult().getError()));
                                    pointMax.getChildResults().get(sci).getChildResults().get(sti).setResult(new Result(stp.getResult().getStatus(), stp.getResultDuration(), stp.getResult().getError()));
                                    continue;
                                }
                                if (stp.getResultDuration() == null || stp.getResultDuration() >= min.getChildResults().get(sci).getChildResults().get(sti).getResultDuration()) continue;
                                min.getChildResults().get(sci).getChildResults().get(sti).setResult(new Result(stp.getResult().getStatus(), stp.getResultDuration(), stp.getResult().getError()));
                                pointMin.getChildResults().get(sci).getChildResults().get(sti).setResult(new Result(stp.getResult().getStatus(), stp.getResultDuration(), stp.getResult().getError()));
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    continue;
                }
                if (!first) continue;
                first = false;
            }
            GroupResult avg = new GroupResult(sum);
            avg.setResult(new Result(avg.getResult().getStatus(), Long.valueOf(avg.getResultDuration() / (long)entry.getValue().size()), avg.getResult().getError()));
            GroupResult cnt = new GroupResult(sum);
            cnt.setResult(new Result(cnt.getResult().getStatus(), Long.valueOf(entry.getValue().size()), null));
            for (sci = 0; sci < sum.getChildResults().size(); ++sci) {
                avg.getChildResults().get(sci).setResult(new Result(sum.getChildResults().get(sci).getResult().getStatus(), Long.valueOf(sum.getChildResults().get(sci).getResultDuration() / (long)entry.getValue().size()), avg.getChildResults().get(sci).getResult().getError()));
                cnt.getChildResults().get(sci).setResult(new Result(sum.getChildResults().get(sci).getResult().getStatus(), Long.valueOf(entry.getValue().size()), null));
                for (int sti = 0; sti < sum.getChildResults().get(sci).getChildResults().size(); ++sti) {
                    if (avg.getChildResults().get(sci).getChildResults().get(sti).getResult().getDuration() == null) continue;
                    avg.getChildResults().get(sci).getChildResults().get(sti).setResult(new Result(avg.getChildResults().get(sci).getChildResults().get(sti).getResult().getStatus(), Long.valueOf(avg.getChildResults().get(sci).getChildResults().get(sti).getResultDuration() / (long)entry.getValue().size()), avg.getChildResults().get(sci).getChildResults().get(sti).getResult().getError()));
                    cnt.getChildResults().get(sci).getChildResults().get(sti).setResult(new Result(cnt.getChildResults().get(sci).getChildResults().get(sti).getResult().getStatus(), Long.valueOf(entry.getValue().size()), null));
                }
            }
            this.stats.getAvg().put(entry.getKey(), avg);
            this.stats.getCnt().put(entry.getKey(), cnt);
            this.stats.getMin().put(entry.getKey(), min);
            this.stats.getMax().put(entry.getKey(), max);
        }
    }

    private long getPeriod(Duration time, int times) {
        return time.getSeconds() * 1000L / (long)times;
    }

    private LocalDateTime getEnd(LocalDateTime start, long timeMillis) {
        LocalDateTime endt = LocalDateTime.from(start).plus(timeMillis, ChronoUnit.MILLIS);
        return endt;
    }

    private HashMap<String, HashMap<String, Throwable>> getErrors() {
        HashMap<String, HashMap<String, Throwable>> map = new HashMap<String, HashMap<String, Throwable>>();
        for (Map.Entry<String, List<GroupResult>> entry : this.results.entrySet()) {
            for (GroupResult f : entry.getValue()) {
                if (!f.getResult().is(Result.Type.FAILED)) continue;
                HashMap<Object, Object> sErrs = new HashMap();
                if (map.containsKey(f.getName())) {
                    sErrs = map.get(f.getName());
                }
                for (ScenarioResult sr : f.getChildResults()) {
                    if (!sr.getResult().is(Result.Type.FAILED)) continue;
                    sErrs.put(sr.getName(), sr.getError());
                }
                map.put(f.getName(), sErrs);
            }
        }
        return map;
    }
}

