/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.runtime.formatter;

import cucumber.perf.api.event.EventHandler;
import cucumber.perf.api.event.EventListener;
import cucumber.perf.api.event.EventPublisher;
import cucumber.perf.api.event.StatisticsFinished;
import cucumber.perf.api.formatter.Statistics;
import cucumber.perf.api.result.GroupResult;
import cucumber.perf.runtime.formatter.AppendableBuilder;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SummaryTextFormatter
implements EventListener {
    private Writer out;
    private final AppendableBuilder builder;
    private List<String> lines = new ArrayList<String>();
    private EventHandler<StatisticsFinished> statsFinishedEventhandler = new EventHandler<StatisticsFinished>(){

        @Override
        public void receive(StatisticsFinished event) {
            SummaryTextFormatter.this.process(event.getResult());
        }
    };

    public SummaryTextFormatter(AppendableBuilder builder) throws IOException {
        this.builder = builder;
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(StatisticsFinished.class, this.statsFinishedEventhandler);
    }

    private void process(Statistics stats) {
        this.reset();
        this.createLines(stats);
        this.finishReport();
    }

    private void reset() {
        this.out = this.builder.build();
        this.lines = new ArrayList<String>();
    }

    private void createLines(Statistics s) {
        if (s.getSimulation() != null) {
            this.lines.add("Simulation: " + s.getSimulation().getName() + " Start: " + s.getSimulation().getStart() + " Stop: " + s.getSimulation().getStop() + " Duration: " + s.getSimulation().getDuration().toString());
        }
        for (Map.Entry<String, GroupResult> entry : s.getAvg().entrySet()) {
            this.lines.add("\tGroup: " + entry.getKey() + " Count: " + s.getCnt().get(entry.getKey()).getResultDuration() + " Avg: " + entry.getValue().getResultDuration() / 1000000L + " Min: " + s.getMin().get(entry.getKey()).getResultDuration() / 1000000L + " Max: " + s.getMax().get(entry.getKey()).getResultDuration() / 1000000L);
            for (int sc = 0; sc < entry.getValue().getChildResults().size(); ++sc) {
                this.lines.add("\t\tScenario: " + entry.getValue().getChildResults().get(sc).getName() + " Count: " + s.getCnt().get(entry.getKey()).getChildResults().get(sc).getResultDuration() + " Avg: " + entry.getValue().getChildResults().get(sc).getResultDuration() / 1000000L + " Min: " + s.getMin().get(entry.getKey()).getChildResults().get(sc).getResultDuration() / 1000000L + " Max: " + s.getMax().get(entry.getKey()).getChildResults().get(sc).getResultDuration() / 1000000L);
                for (int stp = 0; stp < entry.getValue().getChildResults().get(sc).getChildResults().size(); ++stp) {
                    if (entry.getValue().getChildResults().get(sc).getChildResults().get(stp).getResultDuration() == null) continue;
                    this.lines.add("\t\t\tStep: " + entry.getValue().getChildResults().get(sc).getChildResults().get(stp).getName() + " Count: " + s.getCnt().get(entry.getKey()).getChildResults().get(sc).getChildResults().get(stp).getResultDuration() + " Avg: " + entry.getValue().getChildResults().get(sc).getChildResults().get(stp).getResultDuration() / 1000000L + " Min: " + s.getMin().get(entry.getKey()).getChildResults().get(sc).getChildResults().get(stp).getResultDuration() / 1000000L + " Max: " + s.getMax().get(entry.getKey()).getChildResults().get(sc).getChildResults().get(stp).getResultDuration() / 1000000L);
                }
            }
        }
        HashMap<String, HashMap<String, Throwable>> errors = s.getErrors();
        if (!errors.isEmpty()) {
            this.lines.add("Errors:");
            for (Map.Entry<String, HashMap<String, Throwable>> entry : errors.entrySet()) {
                this.lines.add("\tScenario: " + entry.getKey());
                for (Map.Entry<String, Throwable> sentry : entry.getValue().entrySet()) {
                    this.lines.add("\t\tStep: " + entry.getKey());
                    StackTraceElement[] stes = sentry.getValue().getStackTrace();
                    this.lines.add("\t\t" + sentry.getValue().getMessage());
                    for (StackTraceElement ste : stes) {
                        this.lines.add("\t\t" + ste.getClassName() + "." + ste.getMethodName() + "(" + ste.getFileName() + ":" + ste.getLineNumber() + ")");
                    }
                }
            }
        }
    }

    private void finishReport() {
        try (BufferedWriter bw = new BufferedWriter(this.out);){
            for (String line : this.lines) {
                bw.append(line + "\r\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        SummaryTextFormatter.closeQuietly(this.out);
    }

    private static void closeQuietly(Closeable out) {
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

