/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.salad;

import cucumber.perf.salad.AstNode;
import cucumber.perf.salad.Parser;
import cucumber.perf.salad.ParserException;
import cucumber.perf.salad.Token;
import cucumber.perf.salad.ast.Count;
import cucumber.perf.salad.ast.Group;
import cucumber.perf.salad.ast.Plan;
import cucumber.perf.salad.ast.Runners;
import cucumber.perf.salad.ast.SaladDocument;
import cucumber.perf.salad.ast.Simulation;
import cucumber.perf.salad.ast.SimulationDefinition;
import cucumber.perf.salad.ast.SimulationPeriod;
import cucumber.perf.salad.ast.Time;
import gherkin.GherkinLineSpan;
import gherkin.StringUtils;
import gherkin.ast.Comment;
import gherkin.ast.DataTable;
import gherkin.ast.DocString;
import gherkin.ast.Location;
import gherkin.ast.Node;
import gherkin.ast.TableCell;
import gherkin.ast.TableRow;
import gherkin.ast.Tag;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class AstBuilder
implements Parser.Builder<SaladDocument> {
    private Deque<AstNode> stack;
    private List<Comment> comments;

    public AstBuilder() {
        this.reset();
    }

    @Override
    public void reset() {
        this.stack = new ArrayDeque<AstNode>();
        this.stack.push(new AstNode(Parser.RuleType.None));
        this.comments = new ArrayList<Comment>();
    }

    private AstNode currentNode() {
        return this.stack.peek();
    }

    @Override
    public void build(Token token) {
        Parser.RuleType ruleType = Parser.RuleType.cast(token.matchedType);
        if (token.matchedType == Parser.TokenType.Comment) {
            this.comments.add(new Comment(this.getLocation(token, 0), token.matchedText));
        } else {
            this.currentNode().add(ruleType, token);
        }
    }

    @Override
    public void startRule(Parser.RuleType ruleType) {
        this.stack.push(new AstNode(ruleType));
    }

    @Override
    public void endRule(Parser.RuleType ruleType) {
        AstNode node = this.stack.pop();
        Object transformedNode = this.getTransformedNode(node);
        this.currentNode().add(node.ruleType, transformedNode);
    }

    private Object getTransformedNode(AstNode node) {
        switch (node.ruleType) {
            case Group: {
                Token stepLine = node.getToken(Parser.TokenType.GroupLine);
                ArrayList<Node> stepArgs = new ArrayList<Node>();
                Node stepArg = node.getSingle(Parser.RuleType.DataTable, null);
                if (stepArg != null) {
                    stepArgs.add(stepArg);
                }
                if ((stepArg = (Node)node.getSingle(Parser.RuleType.Runners, null)) != null) {
                    stepArgs.add(stepArg);
                }
                if ((stepArg = (Node)node.getSingle(Parser.RuleType.Count, null)) != null) {
                    stepArgs.add(stepArg);
                }
                return new Group(this.getLocation(stepLine, 0), stepLine.matchedKeyword, stepLine.matchedText, stepArgs);
            }
            case Count: {
                Token countLine = node.getToken(Parser.TokenType.CountLine);
                return new Count(this.getLocation(countLine, 0), countLine.matchedKeyword, countLine.matchedText);
            }
            case Runners: {
                Token runnerLine = node.getToken(Parser.TokenType.RunnersLine);
                return new Runners(this.getLocation(runnerLine, 0), runnerLine.matchedKeyword, runnerLine.matchedText);
            }
            case DocString: {
                Token separatorToken = node.getTokens(Parser.TokenType.DocStringSeparator).get(0);
                String contentType = separatorToken.matchedText.length() > 0 ? separatorToken.matchedText : null;
                List<Token> lineTokens = node.getTokens(Parser.TokenType.Other);
                StringBuilder content = new StringBuilder();
                boolean newLine = false;
                for (Token lineToken : lineTokens) {
                    if (newLine) {
                        content.append("\n");
                    }
                    newLine = true;
                    content.append(lineToken.matchedText);
                }
                return new DocString(this.getLocation(separatorToken, 0), contentType, content.toString());
            }
            case DataTable: {
                List<TableRow> rows = this.getTableRows(node);
                return new DataTable(rows);
            }
            case Simulation_Definition: {
                List<Tag> tags = this.getTags(node);
                AstNode simNode = node.getSingle(Parser.RuleType.Simulation, null);
                if (simNode != null) {
                    Token simLine = simNode.getToken(Parser.TokenType.SimulationLine);
                    String description = this.getDescription(simNode);
                    List<Group> steps = this.getGroups(simNode);
                    List rampUp = simNode.getItems(Parser.RuleType.RampUp);
                    List rampDown = simNode.getItems(Parser.RuleType.RampDown);
                    List synchronize = simNode.getItems(Parser.RuleType.Synchronized);
                    List randomWait = simNode.getItems(Parser.RuleType.RandomWait);
                    return new Simulation(tags, this.getLocation(simLine, 0), simLine.matchedKeyword, simLine.matchedText, description, steps, rampUp != null && rampUp.size() > 0 ? (Time)((Object)rampUp.get(0)) : null, rampDown != null && rampDown.size() > 0 ? (Time)((Object)rampDown.get(0)) : null, synchronize != null && synchronize.size() > 0 ? (Count)((Object)synchronize.get(0)) : null, randomWait != null && randomWait.size() > 0 ? (Time)((Object)randomWait.get(0)) : null);
                }
                AstNode simPeriodNode = node.getSingle(Parser.RuleType.SimulationPeriod, null);
                if (simPeriodNode == null) {
                    throw new RuntimeException("Internal grammar error");
                }
                Token simPeriodLine = simPeriodNode.getToken(Parser.TokenType.SimulationPeriodLine);
                String description = this.getDescription(simPeriodNode);
                List<Group> steps = this.getGroups(simPeriodNode);
                List times = simPeriodNode.getItems(Parser.RuleType.Time);
                List rampUp = simPeriodNode.getItems(Parser.RuleType.RampUp);
                List rampDown = simPeriodNode.getItems(Parser.RuleType.RampDown);
                List synchronize = simPeriodNode.getItems(Parser.RuleType.Synchronized);
                List randomWait = simPeriodNode.getItems(Parser.RuleType.RandomWait);
                return new SimulationPeriod(tags, this.getLocation(simPeriodLine, 0), simPeriodLine.matchedKeyword, simPeriodLine.matchedText, description, steps, (Time)((Object)times.get(0)), rampUp != null && rampUp.size() > 0 ? (Time)((Object)rampUp.get(0)) : null, rampDown != null && rampDown.size() > 0 ? (Time)((Object)rampDown.get(0)) : null, synchronize != null && synchronize.size() > 0 ? (Count)((Object)synchronize.get(0)) : null, randomWait != null && randomWait.size() > 0 ? (Time)((Object)randomWait.get(0)) : null);
            }
            case Description: {
                int end;
                List<Token> lineTokens = node.getTokens(Parser.TokenType.Other);
                for (end = lineTokens.size(); end > 0 && lineTokens.get((int)(end - 1)).matchedText.matches("\\s*"); --end) {
                }
                lineTokens = lineTokens.subList(0, end);
                return StringUtils.join((StringUtils.ToString)new StringUtils.ToString<Token>(){

                    public String toString(Token t) {
                        return t.matchedText;
                    }
                }, (String)"\n", lineTokens);
            }
            case Plan: {
                AstNode header = node.getSingle(Parser.RuleType.Plan_Header, new AstNode(Parser.RuleType.Plan_Header));
                if (header == null) {
                    return null;
                }
                List<Tag> tags = this.getTags(header);
                Token planLine = header.getToken(Parser.TokenType.PlanLine);
                if (planLine == null) {
                    return null;
                }
                ArrayList<SimulationDefinition> scenarioDefinitions = new ArrayList<SimulationDefinition>();
                scenarioDefinitions.addAll(node.getItems(Parser.RuleType.Simulation_Definition));
                String description = this.getDescription(header);
                if (planLine.matchedSaladDialect == null) {
                    return null;
                }
                String language = planLine.matchedSaladDialect.getLanguage();
                return new Plan(tags, this.getLocation(planLine, 0), language, planLine.matchedKeyword, planLine.matchedText, description, scenarioDefinitions);
            }
            case SaladDocument: {
                Plan feature = node.getSingle(Parser.RuleType.Plan, null);
                return new SaladDocument(feature, this.comments);
            }
            case Time: {
                Token timeLine = node.getToken(Parser.TokenType.TimeLine);
                return new Time(this.getLocation(timeLine, 0), timeLine.matchedKeyword, timeLine.matchedText);
            }
            case RampUp: {
                Token rupLine = node.getToken(Parser.TokenType.RampUpLine);
                return new Time(this.getLocation(rupLine, 0), rupLine.matchedKeyword, rupLine.matchedText);
            }
            case RampDown: {
                Token rdwnLine = node.getToken(Parser.TokenType.RampDownLine);
                return new Time(this.getLocation(rdwnLine, 0), rdwnLine.matchedKeyword, rdwnLine.matchedText);
            }
            case Synchronized: {
                Token syncLine = node.getToken(Parser.TokenType.SynchronizedLine);
                return new Count(this.getLocation(syncLine, 0), syncLine.matchedKeyword, syncLine.matchedText);
            }
            case RandomWait: {
                Token rwLine = node.getToken(Parser.TokenType.RandomWaitLine);
                return new Time(this.getLocation(rwLine, 0), rwLine.matchedKeyword, rwLine.matchedText);
            }
        }
        return node;
    }

    private List<TableRow> getTableRows(AstNode node) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        for (Token token : node.getTokens(Parser.TokenType.TableRow)) {
            rows.add(new TableRow(this.getLocation(token, 0), this.getCells(token)));
        }
        this.ensureCellCount(rows);
        return rows;
    }

    private void ensureCellCount(List<TableRow> rows) {
        if (rows.isEmpty()) {
            return;
        }
        int cellCount = rows.get(0).getCells().size();
        for (TableRow row : rows) {
            if (row.getCells().size() == cellCount) continue;
            throw new ParserException.AstBuilderException("inconsistent cell count within the table", row.getLocation());
        }
    }

    private List<TableCell> getCells(Token token) {
        ArrayList<TableCell> cells = new ArrayList<TableCell>();
        for (GherkinLineSpan cellItem : token.mathcedItems) {
            cells.add(new TableCell(this.getLocation(token, cellItem.column), cellItem.text));
        }
        return cells;
    }

    private List<Group> getGroups(AstNode node) {
        return node.getItems(Parser.RuleType.Group);
    }

    private Location getLocation(Token token, int column) {
        return column == 0 ? token.location : new Location(token.location.getLine(), column);
    }

    private String getDescription(AstNode node) {
        return node.getSingle(Parser.RuleType.Description, null);
    }

    private List<Tag> getTags(AstNode node) {
        AstNode tagsNode = node.getSingle(Parser.RuleType.Tags, new AstNode(Parser.RuleType.None));
        if (tagsNode == null) {
            return new ArrayList<Tag>();
        }
        List<Token> tokens = tagsNode.getTokens(Parser.TokenType.TagLine);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (Token token : tokens) {
            for (GherkinLineSpan tagItem : token.mathcedItems) {
                tags.add(new Tag(this.getLocation(token, tagItem.column), tagItem.text));
            }
        }
        return tags;
    }

    @Override
    public SaladDocument getResult() {
        return this.currentNode().getSingle(Parser.RuleType.SaladDocument, null);
    }
}

