/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.salad;

import cucumber.perf.salad.ParserException;
import cucumber.perf.salad.Token;
import cucumber.perf.salad.TokenMatcher;
import cucumber.perf.salad.TokenScanner;
import gherkin.Func;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class Parser<T> {
    private final Builder<T> builder;
    public boolean stopAtFirstError;

    public Parser(Builder<T> builder) {
        this.builder = builder;
    }

    public T parse(String source) {
        return this.parse(new StringReader(source));
    }

    public T parse(Reader source) {
        return this.parse(new TokenScanner(source));
    }

    public T parse(ITokenScanner tokenScanner) {
        return this.parse(tokenScanner, (ITokenMatcher)new TokenMatcher());
    }

    public T parse(String source, ITokenMatcher tokenMatcher) {
        return this.parse(new StringReader(source), tokenMatcher);
    }

    public T parse(Reader source, ITokenMatcher tokenMatcher) {
        return this.parse(new TokenScanner(source), tokenMatcher);
    }

    public T parse(ITokenScanner tokenScanner, ITokenMatcher tokenMatcher) {
        Token token;
        this.builder.reset();
        tokenMatcher.reset();
        ParserContext context = new ParserContext(tokenScanner, tokenMatcher, new LinkedList<Token>(), new ArrayList<ParserException>());
        this.startRule(context, RuleType.SaladDocument);
        int state = 0;
        do {
            token = this.readToken(context);
            state = this.matchToken(state, token, context);
        } while (!token.isEOF());
        this.endRule(context, RuleType.SaladDocument);
        if (context.errors.size() > 0) {
            throw new ParserException.CompositeParserException(context.errors);
        }
        return this.builder.getResult();
    }

    private void addError(ParserContext context, ParserException error) {
        context.errors.add(error);
        if (context.errors.size() > 10) {
            throw new ParserException.CompositeParserException(context.errors);
        }
    }

    private <V> V handleAstError(ParserContext context, Func<V> action) {
        return this.handleExternalError(context, action, null);
    }

    private <V> V handleExternalError(ParserContext context, Func<V> action, V defaultValue) {
        if (this.stopAtFirstError) {
            return (V)action.call();
        }
        try {
            return (V)action.call();
        }
        catch (ParserException.CompositeParserException compositeParserException) {
            for (ParserException error : compositeParserException.errors) {
                this.addError(context, error);
            }
        }
        catch (ParserException error) {
            this.addError(context, error);
        }
        return defaultValue;
    }

    private void build(ParserContext context, final Token token) {
        this.handleAstError(context, new Func<Void>(){

            public Void call() {
                Parser.this.builder.build(token);
                return null;
            }
        });
    }

    private void startRule(ParserContext context, final RuleType ruleType) {
        this.handleAstError(context, new Func<Void>(){

            public Void call() {
                Parser.this.builder.startRule(ruleType);
                return null;
            }
        });
    }

    private void endRule(ParserContext context, final RuleType ruleType) {
        this.handleAstError(context, new Func<Void>(){

            public Void call() {
                Parser.this.builder.endRule(ruleType);
                return null;
            }
        });
    }

    private Token readToken(ParserContext context) {
        return context.tokenQueue.size() > 0 ? context.tokenQueue.remove() : context.tokenScanner.read();
    }

    private boolean match_EOF(final ParserContext context, final Token token) {
        return this.handleExternalError(context, new Func<Boolean>(){

            public Boolean call() {
                return context.tokenMatcher.match_EOF(token);
            }
        }, false);
    }

    private boolean match_Empty(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            public Boolean call() {
                return context.tokenMatcher.match_Empty(token);
            }
        }, false);
    }

    private boolean match_Comment(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            public Boolean call() {
                return context.tokenMatcher.match_Comment(token);
            }
        }, false);
    }

    private boolean match_TagLine(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            public Boolean call() {
                return context.tokenMatcher.match_TagLine(token);
            }
        }, false);
    }

    private boolean match_PlanLine(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            public Boolean call() {
                return context.tokenMatcher.match_PlanLine(token);
            }
        }, false);
    }

    private boolean match_SimulationLine(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            public Boolean call() {
                return context.tokenMatcher.match_SimulationLine(token);
            }
        }, false);
    }

    private boolean match_SimulationPeriodLine(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            public Boolean call() {
                return context.tokenMatcher.match_SimulationPeriodLine(token);
            }
        }, false);
    }

    private boolean match_SynchronizedLine(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            public Boolean call() {
                return context.tokenMatcher.match_SynchronizedLine(token);
            }
        }, false);
    }

    private boolean match_TimeLine(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            public Boolean call() {
                return context.tokenMatcher.match_TimeLine(token);
            }
        }, false);
    }

    private boolean match_GroupLine(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            public Boolean call() {
                return context.tokenMatcher.match_GroupLine(token);
            }
        }, false);
    }

    private boolean match_DocStringSeparator(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            public Boolean call() {
                return context.tokenMatcher.match_DocStringSeparator(token);
            }
        }, false);
    }

    private boolean match_TableRow(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            public Boolean call() {
                return context.tokenMatcher.match_TableRow(token);
            }
        }, false);
    }

    private boolean match_Language(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            public Boolean call() {
                return context.tokenMatcher.match_Language(token);
            }
        }, false);
    }

    private boolean match_CountLine(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            public Boolean call() {
                return context.tokenMatcher.match_CountLine(token);
            }
        }, false);
    }

    private boolean match_RandomWaitLine(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            public Boolean call() {
                return context.tokenMatcher.match_RandomWaitLine(token);
            }
        }, false);
    }

    private boolean match_RunnersLine(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            public Boolean call() {
                return context.tokenMatcher.match_RunnersLine(token);
            }
        }, false);
    }

    private boolean match_RampUpLine(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            public Boolean call() {
                return context.tokenMatcher.match_RampUpLine(token);
            }
        }, false);
    }

    private boolean match_RampDownLine(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            public Boolean call() {
                return context.tokenMatcher.match_RampDownLine(token);
            }
        }, false);
    }

    private boolean match_Other(final ParserContext context, final Token token) {
        if (token.isEOF()) {
            return false;
        }
        return this.handleExternalError(context, new Func<Boolean>(){

            public Boolean call() {
                return context.tokenMatcher.match_Other(token);
            }
        }, false);
    }

    private int matchToken(int state, Token token, ParserContext context) {
        int newState;
        switch (state) {
            case 0: {
                newState = this.matchTokenAt_0(token, context);
                break;
            }
            case 1: {
                newState = this.matchTokenAt_1(token, context);
                break;
            }
            case 2: {
                newState = this.matchTokenAt_2(token, context);
                break;
            }
            case 3: {
                newState = this.matchTokenAt_3(token, context);
                break;
            }
            case 4: {
                newState = this.matchTokenAt_4(token, context);
                break;
            }
            case 5: {
                newState = this.matchTokenAt_5(token, context);
                break;
            }
            case 6: {
                newState = this.matchTokenAt_6(token, context);
                break;
            }
            case 7: {
                newState = this.matchTokenAt_7(token, context);
                break;
            }
            case 8: {
                newState = this.matchTokenAt_8(token, context);
                break;
            }
            case 9: {
                newState = this.matchTokenAt_9(token, context);
                break;
            }
            case 10: {
                newState = this.matchTokenAt_10(token, context);
                break;
            }
            case 11: {
                newState = this.matchTokenAt_11(token, context);
                break;
            }
            case 12: {
                newState = this.matchTokenAt_12(token, context);
                break;
            }
            case 13: {
                newState = this.matchTokenAt_13(token, context);
                break;
            }
            case 14: {
                newState = this.matchTokenAt_14(token, context);
                break;
            }
            case 15: {
                newState = this.matchTokenAt_15(token, context);
                break;
            }
            case 16: {
                newState = this.matchTokenAt_16(token, context);
                break;
            }
            case 17: {
                newState = this.matchTokenAt_17(token, context);
                break;
            }
            case 18: {
                newState = this.matchTokenAt_18(token, context);
                break;
            }
            case 19: {
                newState = this.matchTokenAt_19(token, context);
                break;
            }
            case 20: {
                newState = this.matchTokenAt_20(token, context);
                break;
            }
            case 21: {
                newState = this.matchTokenAt_21(token, context);
                break;
            }
            case 22: {
                newState = this.matchTokenAt_22(token, context);
                break;
            }
            case 23: {
                newState = this.matchTokenAt_23(token, context);
                break;
            }
            case 24: {
                newState = this.matchTokenAt_24(token, context);
                break;
            }
            case 25: {
                newState = this.matchTokenAt_25(token, context);
                break;
            }
            case 26: {
                newState = this.matchTokenAt_26(token, context);
                break;
            }
            case 27: {
                newState = this.matchTokenAt_27(token, context);
                break;
            }
            case 28: {
                newState = this.matchTokenAt_28(token, context);
                break;
            }
            case 29: {
                newState = this.matchTokenAt_29(token, context);
                break;
            }
            case 30: {
                newState = this.matchTokenAt_30(token, context);
                break;
            }
            case 31: {
                newState = this.matchTokenAt_31(token, context);
                break;
            }
            case 32: {
                newState = this.matchTokenAt_32(token, context);
                break;
            }
            case 33: {
                newState = this.matchTokenAt_33(token, context);
                break;
            }
            case 34: {
                newState = this.matchTokenAt_34(token, context);
                break;
            }
            case 35: {
                newState = this.matchTokenAt_35(token, context);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + state);
            }
        }
        return newState;
    }

    private int matchTokenAt_0(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.build(context, token);
            return 36;
        }
        if (this.match_Language(context, token)) {
            this.startRule(context, RuleType.Plan);
            this.startRule(context, RuleType.Plan_Header);
            this.build(context, token);
            return 1;
        }
        if (this.match_TagLine(context, token)) {
            this.startRule(context, RuleType.Plan);
            this.startRule(context, RuleType.Plan_Header);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 2;
        }
        if (this.match_PlanLine(context, token)) {
            this.startRule(context, RuleType.Plan);
            this.startRule(context, RuleType.Plan_Header);
            this.build(context, token);
            return 3;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 0;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 0;
        }
        String stateComment = "State: 0 - Start";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Language", "#TagLine", "#PlanLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 0 - Start") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 0 - Start");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 0;
    }

    private int matchTokenAt_1(Token token, ParserContext context) {
        ParserException error;
        if (this.match_TagLine(context, token)) {
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 2;
        }
        if (this.match_PlanLine(context, token)) {
            this.build(context, token);
            return 3;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 1;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 1;
        }
        String stateComment = "State: 1 - SaladDocument:0>Plan:0>Plan_Header:0>#Language:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#TagLine", "#PlanLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 1 - SaladDocument:0>Plan:0>Plan_Header:0>#Language:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 1 - SaladDocument:0>Plan:0>Plan_Header:0>#Language:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 1;
    }

    private int matchTokenAt_2(Token token, ParserContext context) {
        ParserException error;
        if (this.match_TagLine(context, token)) {
            this.build(context, token);
            return 2;
        }
        if (this.match_PlanLine(context, token)) {
            this.endRule(context, RuleType.Tags);
            this.build(context, token);
            return 3;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 2;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 2;
        }
        String stateComment = "State: 2 - SaladDocument:0>Plan:0>Plan_Header:1>Tags:0>#TagLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#TagLine", "#PlanLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 2 - SaladDocument:0>Plan:0>Plan_Header:1>Tags:0>#TagLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 2 - SaladDocument:0>Plan:0>Plan_Header:1>Tags:0>#TagLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 2;
    }

    private int matchTokenAt_3(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Plan_Header);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 3;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 5;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Plan_Header);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.Plan_Header);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.Plan_Header);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Other(context, token)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token);
            return 4;
        }
        String stateComment = "State: 3 - SaladDocument:0>Plan:0>Plan_Header:2>#PlanLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Other");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 3 - SaladDocument:0>Plan:0>Plan_Header:2>#PlanLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 3 - SaladDocument:0>Plan:0>Plan_Header:2>#PlanLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 3;
    }

    private int matchTokenAt_4(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Plan_Header);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_Comment(context, token)) {
            this.endRule(context, RuleType.Description);
            this.build(context, token);
            return 5;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Plan_Header);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Plan_Header);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Plan_Header);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Other(context, token)) {
            this.build(context, token);
            return 4;
        }
        String stateComment = "State: 4 - SaladDocument:0>Plan:0>Plan_Header:3>Description_Helper:1>Description:0>#Other:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Other");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 4 - SaladDocument:0>Plan:0>Plan_Header:3>Description_Helper:1>Description:0>#Other:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 4 - SaladDocument:0>Plan:0>Plan_Header:3>Description_Helper:1>Description:0>#Other:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 4;
    }

    private int matchTokenAt_5(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Plan_Header);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 5;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Plan_Header);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.Plan_Header);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.Plan_Header);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 5;
        }
        String stateComment = "State: 5 - SaladDocument:0>Plan:0>Plan_Header:3>Description_Helper:2>#Comment:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 5 - SaladDocument:0>Plan:0>Plan_Header:3>Description_Helper:2>#Comment:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 5 - SaladDocument:0>Plan:0>Plan_Header:3>Description_Helper:2>#Comment:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 5;
    }

    private int matchTokenAt_6(Token token, ParserContext context) {
        ParserException error;
        if (this.match_TagLine(context, token)) {
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.Tags);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.Tags);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 6;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 6;
        }
        String stateComment = "State: 6 - SaladDocument:0>Plan:1>Simulation_Definition:0>Tags:0>#TagLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 6 - SaladDocument:0>Plan:1>Simulation_Definition:0>Tags:0>#TagLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 6 - SaladDocument:0>Plan:1>Simulation_Definition:0>Tags:0>#TagLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 6;
    }

    private int matchTokenAt_7(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 7;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 9;
        }
        if (this.match_GroupLine(context, token)) {
            this.startRule(context, RuleType.Group);
            this.build(context, token);
            return 10;
        }
        if (this.match_SynchronizedLine(context, token)) {
            this.startRule(context, RuleType.Synchronized);
            this.build(context, token);
            return 16;
        }
        if (this.match_RampUpLine(context, token)) {
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 17;
        }
        if (this.match_RampDownLine(context, token)) {
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 18;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 19;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Other(context, token)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token);
            return 8;
        }
        String stateComment = "State: 7 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:0>#SimulationLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#GroupLine", "#SynchronizedLine", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Other");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 7 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:0>#SimulationLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 7 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:0>#SimulationLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 7;
    }

    private int matchTokenAt_8(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_Comment(context, token)) {
            this.endRule(context, RuleType.Description);
            this.build(context, token);
            return 9;
        }
        if (this.match_GroupLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.Group);
            this.build(context, token);
            return 10;
        }
        if (this.match_SynchronizedLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.Synchronized);
            this.build(context, token);
            return 16;
        }
        if (this.match_RampUpLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 17;
        }
        if (this.match_RampDownLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 18;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 19;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Other(context, token)) {
            this.build(context, token);
            return 8;
        }
        String stateComment = "State: 8 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:1>Description_Helper:1>Description:0>#Other:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#GroupLine", "#SynchronizedLine", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Other");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 8 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:1>Description_Helper:1>Description:0>#Other:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 8 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:1>Description_Helper:1>Description:0>#Other:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 8;
    }

    private int matchTokenAt_9(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 9;
        }
        if (this.match_GroupLine(context, token)) {
            this.startRule(context, RuleType.Group);
            this.build(context, token);
            return 10;
        }
        if (this.match_SynchronizedLine(context, token)) {
            this.startRule(context, RuleType.Synchronized);
            this.build(context, token);
            return 16;
        }
        if (this.match_RampUpLine(context, token)) {
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 17;
        }
        if (this.match_RampDownLine(context, token)) {
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 18;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 19;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 9;
        }
        String stateComment = "State: 9 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:1>Description_Helper:2>#Comment:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#GroupLine", "#SynchronizedLine", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 9 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:1>Description_Helper:2>#Comment:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 9 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:1>Description_Helper:2>#Comment:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 9;
    }

    private int matchTokenAt_10(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_TableRow(context, token)) {
            this.startRule(context, RuleType.DataTable);
            this.build(context, token);
            return 11;
        }
        if (this.match_DocStringSeparator(context, token)) {
            this.startRule(context, RuleType.DocString);
            this.build(context, token);
            return 12;
        }
        if (this.match_RunnersLine(context, token)) {
            this.startRule(context, RuleType.Runners);
            this.build(context, token);
            return 14;
        }
        if (this.match_CountLine(context, token)) {
            this.startRule(context, RuleType.Count);
            this.build(context, token);
            return 15;
        }
        if (this.match_GroupLine(context, token)) {
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Group);
            this.build(context, token);
            return 10;
        }
        if (this.match_SynchronizedLine(context, token)) {
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Synchronized);
            this.build(context, token);
            return 16;
        }
        if (this.match_RampUpLine(context, token)) {
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 17;
        }
        if (this.match_RampDownLine(context, token)) {
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 18;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 19;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 10;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 10;
        }
        String stateComment = "State: 10 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:2>Group:0>#GroupLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#DocStringSeparator", "#RunnersLine", "#CountLine", "#GroupLine", "#SynchronizedLine", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 10 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:2>Group:0>#GroupLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 10 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:2>Group:0>#GroupLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 10;
    }

    private int matchTokenAt_11(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_TableRow(context, token)) {
            this.build(context, token);
            return 11;
        }
        if (this.match_DocStringSeparator(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.startRule(context, RuleType.DocString);
            this.build(context, token);
            return 12;
        }
        if (this.match_RunnersLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.startRule(context, RuleType.Runners);
            this.build(context, token);
            return 14;
        }
        if (this.match_CountLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.startRule(context, RuleType.Count);
            this.build(context, token);
            return 15;
        }
        if (this.match_GroupLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Group);
            this.build(context, token);
            return 10;
        }
        if (this.match_SynchronizedLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Synchronized);
            this.build(context, token);
            return 16;
        }
        if (this.match_RampUpLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 17;
        }
        if (this.match_RampDownLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 18;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 19;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 11;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 11;
        }
        String stateComment = "State: 11 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:2>Group:1>Group_Arg:0>DataTable:0>#TableRow:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#DocStringSeparator", "#RunnersLine", "#CountLine", "#GroupLine", "#SynchronizedLine", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 11 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:2>Group:1>Group_Arg:0>DataTable:0>#TableRow:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 11 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:2>Group:1>Group_Arg:0>DataTable:0>#TableRow:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 11;
    }

    private int matchTokenAt_12(Token token, ParserContext context) {
        ParserException error;
        if (this.match_DocStringSeparator(context, token)) {
            this.build(context, token);
            return 13;
        }
        if (this.match_Other(context, token)) {
            this.build(context, token);
            return 12;
        }
        String stateComment = "State: 12 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:2>Group:1>Group_Arg:1>DocString:0>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#DocStringSeparator", "#Other");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 12 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:2>Group:1>Group_Arg:1>DocString:0>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 12 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:2>Group:1>Group_Arg:1>DocString:0>#DocStringSeparator:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 12;
    }

    private int matchTokenAt_13(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_RunnersLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.startRule(context, RuleType.Runners);
            this.build(context, token);
            return 14;
        }
        if (this.match_CountLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.startRule(context, RuleType.Count);
            this.build(context, token);
            return 15;
        }
        if (this.match_GroupLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Group);
            this.build(context, token);
            return 10;
        }
        if (this.match_SynchronizedLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Synchronized);
            this.build(context, token);
            return 16;
        }
        if (this.match_RampUpLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 17;
        }
        if (this.match_RampDownLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 18;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 19;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 13;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 13;
        }
        String stateComment = "State: 13 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:2>Group:1>Group_Arg:1>DocString:2>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#RunnersLine", "#CountLine", "#GroupLine", "#SynchronizedLine", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 13 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:2>Group:1>Group_Arg:1>DocString:2>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 13 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:2>Group:1>Group_Arg:1>DocString:2>#DocStringSeparator:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 13;
    }

    private int matchTokenAt_14(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_RunnersLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.startRule(context, RuleType.Runners);
            this.build(context, token);
            return 14;
        }
        if (this.match_CountLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.startRule(context, RuleType.Count);
            this.build(context, token);
            return 15;
        }
        if (this.match_GroupLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Group);
            this.build(context, token);
            return 10;
        }
        if (this.match_SynchronizedLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Synchronized);
            this.build(context, token);
            return 16;
        }
        if (this.match_RampUpLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 17;
        }
        if (this.match_RampDownLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 18;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 19;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 14;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 14;
        }
        String stateComment = "State: 14 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:2>Group:1>Group_Arg:2>Runners:0>#RunnersLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#RunnersLine", "#CountLine", "#GroupLine", "#SynchronizedLine", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 14 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:2>Group:1>Group_Arg:2>Runners:0>#RunnersLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 14 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:2>Group:1>Group_Arg:2>Runners:0>#RunnersLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 14;
    }

    private int matchTokenAt_15(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Count);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_GroupLine(context, token)) {
            this.endRule(context, RuleType.Count);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Group);
            this.build(context, token);
            return 10;
        }
        if (this.match_SynchronizedLine(context, token)) {
            this.endRule(context, RuleType.Count);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Synchronized);
            this.build(context, token);
            return 16;
        }
        if (this.match_RampUpLine(context, token)) {
            this.endRule(context, RuleType.Count);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 17;
        }
        if (this.match_RampDownLine(context, token)) {
            this.endRule(context, RuleType.Count);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 18;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.Count);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 19;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Count);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.Count);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.Count);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 15;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 15;
        }
        String stateComment = "State: 15 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:2>Group:1>Group_Arg:3>Count:0>#CountLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#GroupLine", "#SynchronizedLine", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 15 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:2>Group:1>Group_Arg:3>Count:0>#CountLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 15 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:2>Group:1>Group_Arg:3>Count:0>#CountLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 15;
    }

    private int matchTokenAt_16(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Synchronized);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_RampUpLine(context, token)) {
            this.endRule(context, RuleType.Synchronized);
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 17;
        }
        if (this.match_RampDownLine(context, token)) {
            this.endRule(context, RuleType.Synchronized);
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 18;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.Synchronized);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 19;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Synchronized);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.Synchronized);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.Synchronized);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 16;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 16;
        }
        String stateComment = "State: 16 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:3>Synchronized:0>#SynchronizedLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 16 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:3>Synchronized:0>#SynchronizedLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 16 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:3>Synchronized:0>#SynchronizedLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 16;
    }

    private int matchTokenAt_17(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.RampUp);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_RampDownLine(context, token)) {
            this.endRule(context, RuleType.RampUp);
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 18;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.RampUp);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 19;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.RampUp);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.RampUp);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.RampUp);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 17;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 17;
        }
        String stateComment = "State: 17 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:4>RampUp:0>#RampUpLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 17 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:4>RampUp:0>#RampUpLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 17 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:4>RampUp:0>#RampUpLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 17;
    }

    private int matchTokenAt_18(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.RampDown);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.RampDown);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 19;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.RampDown);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.RampDown);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.RampDown);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 18;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 18;
        }
        String stateComment = "State: 18 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:5>RampDown:0>#RampDownLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 18 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:5>RampDown:0>#RampDownLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 18 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:5>RampDown:0>#RampDownLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 18;
    }

    private int matchTokenAt_19(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.RandomWait);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.RandomWait);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.RandomWait);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.RandomWait);
            this.endRule(context, RuleType.Simulation);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 19;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 19;
        }
        String stateComment = "State: 19 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:6>RandomWait:0>#RandomWaitLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 19 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:6>RandomWait:0>#RandomWaitLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 19 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:0>Simulation:6>RandomWait:0>#RandomWaitLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 19;
    }

    private int matchTokenAt_20(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 22;
        }
        if (this.match_GroupLine(context, token)) {
            this.startRule(context, RuleType.Group);
            this.build(context, token);
            return 23;
        }
        if (this.match_TimeLine(context, token)) {
            this.startRule(context, RuleType.Time);
            this.build(context, token);
            return 29;
        }
        if (this.match_SynchronizedLine(context, token)) {
            this.startRule(context, RuleType.Synchronized);
            this.build(context, token);
            return 32;
        }
        if (this.match_RampUpLine(context, token)) {
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 33;
        }
        if (this.match_RampDownLine(context, token)) {
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 34;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Other(context, token)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token);
            return 21;
        }
        String stateComment = "State: 20 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:0>#SimulationPeriodLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#GroupLine", "#TimeLine", "#SynchronizedLine", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Other");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 20 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:0>#SimulationPeriodLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 20 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:0>#SimulationPeriodLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 20;
    }

    private int matchTokenAt_21(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_Comment(context, token)) {
            this.endRule(context, RuleType.Description);
            this.build(context, token);
            return 22;
        }
        if (this.match_GroupLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.Group);
            this.build(context, token);
            return 23;
        }
        if (this.match_TimeLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.Time);
            this.build(context, token);
            return 29;
        }
        if (this.match_SynchronizedLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.Synchronized);
            this.build(context, token);
            return 32;
        }
        if (this.match_RampUpLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 33;
        }
        if (this.match_RampDownLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 34;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Other(context, token)) {
            this.build(context, token);
            return 21;
        }
        String stateComment = "State: 21 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:1>Description_Helper:1>Description:0>#Other:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#GroupLine", "#TimeLine", "#SynchronizedLine", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Other");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 21 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:1>Description_Helper:1>Description:0>#Other:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 21 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:1>Description_Helper:1>Description:0>#Other:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 21;
    }

    private int matchTokenAt_22(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 22;
        }
        if (this.match_GroupLine(context, token)) {
            this.startRule(context, RuleType.Group);
            this.build(context, token);
            return 23;
        }
        if (this.match_TimeLine(context, token)) {
            this.startRule(context, RuleType.Time);
            this.build(context, token);
            return 29;
        }
        if (this.match_SynchronizedLine(context, token)) {
            this.startRule(context, RuleType.Synchronized);
            this.build(context, token);
            return 32;
        }
        if (this.match_RampUpLine(context, token)) {
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 33;
        }
        if (this.match_RampDownLine(context, token)) {
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 34;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 22;
        }
        String stateComment = "State: 22 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:1>Description_Helper:2>#Comment:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#GroupLine", "#TimeLine", "#SynchronizedLine", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 22 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:1>Description_Helper:2>#Comment:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 22 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:1>Description_Helper:2>#Comment:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 22;
    }

    private int matchTokenAt_23(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_TableRow(context, token)) {
            this.startRule(context, RuleType.DataTable);
            this.build(context, token);
            return 24;
        }
        if (this.match_DocStringSeparator(context, token)) {
            this.startRule(context, RuleType.DocString);
            this.build(context, token);
            return 25;
        }
        if (this.match_RunnersLine(context, token)) {
            this.startRule(context, RuleType.Runners);
            this.build(context, token);
            return 27;
        }
        if (this.match_CountLine(context, token)) {
            this.startRule(context, RuleType.Count);
            this.build(context, token);
            return 28;
        }
        if (this.match_GroupLine(context, token)) {
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Group);
            this.build(context, token);
            return 23;
        }
        if (this.match_TimeLine(context, token)) {
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Time);
            this.build(context, token);
            return 29;
        }
        if (this.match_SynchronizedLine(context, token)) {
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Synchronized);
            this.build(context, token);
            return 32;
        }
        if (this.match_RampUpLine(context, token)) {
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 33;
        }
        if (this.match_RampDownLine(context, token)) {
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 34;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 23;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 23;
        }
        String stateComment = "State: 23 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:2>Group:0>#GroupLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#DocStringSeparator", "#RunnersLine", "#CountLine", "#GroupLine", "#TimeLine", "#SynchronizedLine", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 23 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:2>Group:0>#GroupLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 23 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:2>Group:0>#GroupLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 23;
    }

    private int matchTokenAt_24(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_TableRow(context, token)) {
            this.build(context, token);
            return 24;
        }
        if (this.match_DocStringSeparator(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.startRule(context, RuleType.DocString);
            this.build(context, token);
            return 25;
        }
        if (this.match_RunnersLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.startRule(context, RuleType.Runners);
            this.build(context, token);
            return 27;
        }
        if (this.match_CountLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.startRule(context, RuleType.Count);
            this.build(context, token);
            return 28;
        }
        if (this.match_GroupLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Group);
            this.build(context, token);
            return 23;
        }
        if (this.match_TimeLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Time);
            this.build(context, token);
            return 29;
        }
        if (this.match_SynchronizedLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Synchronized);
            this.build(context, token);
            return 32;
        }
        if (this.match_RampUpLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 33;
        }
        if (this.match_RampDownLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 34;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.DataTable);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 24;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 24;
        }
        String stateComment = "State: 24 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:2>Group:1>Group_Arg:0>DataTable:0>#TableRow:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#TableRow", "#DocStringSeparator", "#RunnersLine", "#CountLine", "#GroupLine", "#TimeLine", "#SynchronizedLine", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 24 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:2>Group:1>Group_Arg:0>DataTable:0>#TableRow:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 24 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:2>Group:1>Group_Arg:0>DataTable:0>#TableRow:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 24;
    }

    private int matchTokenAt_25(Token token, ParserContext context) {
        ParserException error;
        if (this.match_DocStringSeparator(context, token)) {
            this.build(context, token);
            return 26;
        }
        if (this.match_Other(context, token)) {
            this.build(context, token);
            return 25;
        }
        String stateComment = "State: 25 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:2>Group:1>Group_Arg:1>DocString:0>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#DocStringSeparator", "#Other");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 25 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:2>Group:1>Group_Arg:1>DocString:0>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 25 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:2>Group:1>Group_Arg:1>DocString:0>#DocStringSeparator:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 25;
    }

    private int matchTokenAt_26(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_RunnersLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.startRule(context, RuleType.Runners);
            this.build(context, token);
            return 27;
        }
        if (this.match_CountLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.startRule(context, RuleType.Count);
            this.build(context, token);
            return 28;
        }
        if (this.match_GroupLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Group);
            this.build(context, token);
            return 23;
        }
        if (this.match_TimeLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Time);
            this.build(context, token);
            return 29;
        }
        if (this.match_SynchronizedLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Synchronized);
            this.build(context, token);
            return 32;
        }
        if (this.match_RampUpLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 33;
        }
        if (this.match_RampDownLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 34;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.DocString);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 26;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 26;
        }
        String stateComment = "State: 26 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:2>Group:1>Group_Arg:1>DocString:2>#DocStringSeparator:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#RunnersLine", "#CountLine", "#GroupLine", "#TimeLine", "#SynchronizedLine", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 26 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:2>Group:1>Group_Arg:1>DocString:2>#DocStringSeparator:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 26 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:2>Group:1>Group_Arg:1>DocString:2>#DocStringSeparator:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 26;
    }

    private int matchTokenAt_27(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_RunnersLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.startRule(context, RuleType.Runners);
            this.build(context, token);
            return 27;
        }
        if (this.match_CountLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.startRule(context, RuleType.Count);
            this.build(context, token);
            return 28;
        }
        if (this.match_GroupLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Group);
            this.build(context, token);
            return 23;
        }
        if (this.match_TimeLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Time);
            this.build(context, token);
            return 29;
        }
        if (this.match_SynchronizedLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Synchronized);
            this.build(context, token);
            return 32;
        }
        if (this.match_RampUpLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 33;
        }
        if (this.match_RampDownLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 34;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.Runners);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 27;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 27;
        }
        String stateComment = "State: 27 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:2>Group:1>Group_Arg:2>Runners:0>#RunnersLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#RunnersLine", "#CountLine", "#GroupLine", "#TimeLine", "#SynchronizedLine", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 27 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:2>Group:1>Group_Arg:2>Runners:0>#RunnersLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 27 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:2>Group:1>Group_Arg:2>Runners:0>#RunnersLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 27;
    }

    private int matchTokenAt_28(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Count);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_GroupLine(context, token)) {
            this.endRule(context, RuleType.Count);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Group);
            this.build(context, token);
            return 23;
        }
        if (this.match_TimeLine(context, token)) {
            this.endRule(context, RuleType.Count);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Time);
            this.build(context, token);
            return 29;
        }
        if (this.match_SynchronizedLine(context, token)) {
            this.endRule(context, RuleType.Count);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.Synchronized);
            this.build(context, token);
            return 32;
        }
        if (this.match_RampUpLine(context, token)) {
            this.endRule(context, RuleType.Count);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 33;
        }
        if (this.match_RampDownLine(context, token)) {
            this.endRule(context, RuleType.Count);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 34;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.Count);
            this.endRule(context, RuleType.Group);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Count);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.Count);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.Count);
            this.endRule(context, RuleType.Group);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 28;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 28;
        }
        String stateComment = "State: 28 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:2>Group:1>Group_Arg:3>Count:0>#CountLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#GroupLine", "#TimeLine", "#SynchronizedLine", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 28 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:2>Group:1>Group_Arg:3>Count:0>#CountLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 28 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:2>Group:1>Group_Arg:3>Count:0>#CountLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 28;
    }

    private int matchTokenAt_29(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Time);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 29;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 31;
        }
        if (this.match_TimeLine(context, token)) {
            this.endRule(context, RuleType.Time);
            this.startRule(context, RuleType.Time);
            this.build(context, token);
            return 29;
        }
        if (this.match_SynchronizedLine(context, token)) {
            this.endRule(context, RuleType.Time);
            this.startRule(context, RuleType.Synchronized);
            this.build(context, token);
            return 32;
        }
        if (this.match_RampUpLine(context, token)) {
            this.endRule(context, RuleType.Time);
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 33;
        }
        if (this.match_RampDownLine(context, token)) {
            this.endRule(context, RuleType.Time);
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 34;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.Time);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Time);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.Time);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.Time);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Other(context, token)) {
            this.startRule(context, RuleType.Description);
            this.build(context, token);
            return 30;
        }
        String stateComment = "State: 29 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:3>Time:0>#TimeLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Empty", "#Comment", "#TimeLine", "#SynchronizedLine", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Other");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 29 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:3>Time:0>#TimeLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 29 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:3>Time:0>#TimeLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 29;
    }

    private int matchTokenAt_30(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Time);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_Comment(context, token)) {
            this.endRule(context, RuleType.Description);
            this.build(context, token);
            return 31;
        }
        if (this.match_TimeLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Time);
            this.startRule(context, RuleType.Time);
            this.build(context, token);
            return 29;
        }
        if (this.match_SynchronizedLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Time);
            this.startRule(context, RuleType.Synchronized);
            this.build(context, token);
            return 32;
        }
        if (this.match_RampUpLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Time);
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 33;
        }
        if (this.match_RampDownLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Time);
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 34;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Time);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Time);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Time);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.Description);
            this.endRule(context, RuleType.Time);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Other(context, token)) {
            this.build(context, token);
            return 30;
        }
        String stateComment = "State: 30 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:3>Time:1>Description_Helper:1>Description:0>#Other:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#TimeLine", "#SynchronizedLine", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Other");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 30 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:3>Time:1>Description_Helper:1>Description:0>#Other:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 30 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:3>Time:1>Description_Helper:1>Description:0>#Other:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 30;
    }

    private int matchTokenAt_31(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Time);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 31;
        }
        if (this.match_TimeLine(context, token)) {
            this.endRule(context, RuleType.Time);
            this.startRule(context, RuleType.Time);
            this.build(context, token);
            return 29;
        }
        if (this.match_SynchronizedLine(context, token)) {
            this.endRule(context, RuleType.Time);
            this.startRule(context, RuleType.Synchronized);
            this.build(context, token);
            return 32;
        }
        if (this.match_RampUpLine(context, token)) {
            this.endRule(context, RuleType.Time);
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 33;
        }
        if (this.match_RampDownLine(context, token)) {
            this.endRule(context, RuleType.Time);
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 34;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.Time);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Time);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.Time);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.Time);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 31;
        }
        String stateComment = "State: 31 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:3>Time:1>Description_Helper:2>#Comment:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#Comment", "#TimeLine", "#SynchronizedLine", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 31 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:3>Time:1>Description_Helper:2>#Comment:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 31 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:3>Time:1>Description_Helper:2>#Comment:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 31;
    }

    private int matchTokenAt_32(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.Synchronized);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_RampUpLine(context, token)) {
            this.endRule(context, RuleType.Synchronized);
            this.startRule(context, RuleType.RampUp);
            this.build(context, token);
            return 33;
        }
        if (this.match_RampDownLine(context, token)) {
            this.endRule(context, RuleType.Synchronized);
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 34;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.Synchronized);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.Synchronized);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.Synchronized);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.Synchronized);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 32;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 32;
        }
        String stateComment = "State: 32 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:4>Synchronized:0>#SynchronizedLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#RampUpLine", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 32 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:4>Synchronized:0>#SynchronizedLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 32 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:4>Synchronized:0>#SynchronizedLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 32;
    }

    private int matchTokenAt_33(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.RampUp);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_RampDownLine(context, token)) {
            this.endRule(context, RuleType.RampUp);
            this.startRule(context, RuleType.RampDown);
            this.build(context, token);
            return 34;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.RampUp);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.RampUp);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.RampUp);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.RampUp);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 33;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 33;
        }
        String stateComment = "State: 33 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:5>RampUp:0>#RampUpLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#RampDownLine", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 33 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:5>RampUp:0>#RampUpLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 33 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:5>RampUp:0>#RampUpLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 33;
    }

    private int matchTokenAt_34(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.RampDown);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_RandomWaitLine(context, token)) {
            this.endRule(context, RuleType.RampDown);
            this.startRule(context, RuleType.RandomWait);
            this.build(context, token);
            return 35;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.RampDown);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.RampDown);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.RampDown);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 34;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 34;
        }
        String stateComment = "State: 34 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:6>RampDown:0>#RampDownLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#RandomWaitLine", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 34 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:6>RampDown:0>#RampDownLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 34 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:6>RampDown:0>#RampDownLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 34;
    }

    private int matchTokenAt_35(Token token, ParserContext context) {
        ParserException error;
        if (this.match_EOF(context, token)) {
            this.endRule(context, RuleType.RandomWait);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.endRule(context, RuleType.Plan);
            this.build(context, token);
            return 36;
        }
        if (this.match_TagLine(context, token)) {
            this.endRule(context, RuleType.RandomWait);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Tags);
            this.build(context, token);
            return 6;
        }
        if (this.match_SimulationLine(context, token)) {
            this.endRule(context, RuleType.RandomWait);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation);
            this.build(context, token);
            return 7;
        }
        if (this.match_SimulationPeriodLine(context, token)) {
            this.endRule(context, RuleType.RandomWait);
            this.endRule(context, RuleType.SimulationPeriod);
            this.endRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.Simulation_Definition);
            this.startRule(context, RuleType.SimulationPeriod);
            this.build(context, token);
            return 20;
        }
        if (this.match_Comment(context, token)) {
            this.build(context, token);
            return 35;
        }
        if (this.match_Empty(context, token)) {
            this.build(context, token);
            return 35;
        }
        String stateComment = "State: 35 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:7>RandomWait:0>#RandomWaitLine:0";
        token.detach();
        List<String> expectedTokens = Arrays.asList("#EOF", "#TagLine", "#SimulationLine", "#SimulationPeriodLine", "#Comment", "#Empty");
        ParserException parserException = error = token.isEOF() ? new ParserException.UnexpectedEOFException(token, expectedTokens, "State: 35 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:7>RandomWait:0>#RandomWaitLine:0") : new ParserException.UnexpectedTokenException(token, expectedTokens, "State: 35 - SaladDocument:0>Plan:1>Simulation_Definition:1>__alt0:1>SimulationPeriod:7>RandomWait:0>#RandomWaitLine:0");
        if (this.stopAtFirstError) {
            throw error;
        }
        this.addError(context, error);
        return 35;
    }

    public static interface ITokenMatcher {
        public boolean match_EOF(Token var1);

        public boolean match_Empty(Token var1);

        public boolean match_Comment(Token var1);

        public boolean match_TagLine(Token var1);

        public boolean match_PlanLine(Token var1);

        public boolean match_SimulationLine(Token var1);

        public boolean match_SimulationPeriodLine(Token var1);

        public boolean match_SynchronizedLine(Token var1);

        public boolean match_TimeLine(Token var1);

        public boolean match_GroupLine(Token var1);

        public boolean match_DocStringSeparator(Token var1);

        public boolean match_TableRow(Token var1);

        public boolean match_Language(Token var1);

        public boolean match_CountLine(Token var1);

        public boolean match_RandomWaitLine(Token var1);

        public boolean match_RunnersLine(Token var1);

        public boolean match_RampUpLine(Token var1);

        public boolean match_RampDownLine(Token var1);

        public boolean match_Other(Token var1);

        public void reset();
    }

    public static interface ITokenScanner {
        public Token read();
    }

    public static interface Builder<T> {
        public void build(Token var1);

        public void startRule(RuleType var1);

        public void endRule(RuleType var1);

        public T getResult();

        public void reset();
    }

    class ParserContext {
        public final ITokenScanner tokenScanner;
        public final ITokenMatcher tokenMatcher;
        public final Queue<Token> tokenQueue;
        public final List<ParserException> errors;

        ParserContext(ITokenScanner tokenScanner, ITokenMatcher tokenMatcher, Queue<Token> tokenQueue, List<ParserException> errors) {
            this.tokenScanner = tokenScanner;
            this.tokenMatcher = tokenMatcher;
            this.tokenQueue = tokenQueue;
            this.errors = errors;
        }
    }

    public static enum RuleType {
        None,
        _EOF,
        _Empty,
        _Comment,
        _TagLine,
        _PlanLine,
        _SimulationLine,
        _SimulationPeriodLine,
        _SynchronizedLine,
        _TimeLine,
        _GroupLine,
        _DocStringSeparator,
        _TableRow,
        _Language,
        _CountLine,
        _RandomWaitLine,
        _RunnersLine,
        _RampUpLine,
        _RampDownLine,
        _Other,
        SaladDocument,
        Plan,
        Plan_Header,
        Simulation_Definition,
        Simulation,
        SimulationPeriod,
        Time,
        Group,
        Group_Arg,
        DataTable,
        DocString,
        Runners,
        Count,
        RampUp,
        RampDown,
        Tags,
        Synchronized,
        RandomWait,
        Description_Helper,
        Description;


        public static RuleType cast(TokenType tokenType) {
            return RuleType.values()[tokenType.ordinal()];
        }
    }

    public static enum TokenType {
        None,
        EOF,
        Empty,
        Comment,
        TagLine,
        PlanLine,
        SimulationLine,
        SimulationPeriodLine,
        SynchronizedLine,
        TimeLine,
        GroupLine,
        DocStringSeparator,
        TableRow,
        Language,
        CountLine,
        RandomWaitLine,
        RunnersLine,
        RampUpLine,
        RampDownLine,
        Other;

    }
}

