/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.salad;

import cucumber.perf.salad.ISaladDialectProvider;
import cucumber.perf.salad.ParserException;
import cucumber.perf.salad.SaladDialect;
import gherkin.ast.Location;
import gherkin.deps.com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SaladDialectProvider
implements ISaladDialectProvider {
    private static Map<String, Map<String, List<String>>> DIALECTS;
    private final String default_dialect_name;

    public SaladDialectProvider(String default_dialect_name) {
        this.default_dialect_name = default_dialect_name;
    }

    public SaladDialectProvider() {
        this("en");
    }

    @Override
    public SaladDialect getDefaultDialect() {
        return this.getDialect(this.default_dialect_name, null);
    }

    @Override
    public SaladDialect getDialect(String language, Location location) {
        Map<String, List<String>> map = DIALECTS.get(language);
        if (map == null) {
            throw new ParserException.NoSuchLanguageException(language, location);
        }
        return new SaladDialect(language, map);
    }

    @Override
    public List<String> getLanguages() {
        ArrayList<String> languages = new ArrayList<String>(DIALECTS.keySet());
        Collections.sort(languages);
        return Collections.unmodifiableList(languages);
    }

    static {
        Gson gson = new Gson();
        try {
            InputStreamReader dialects = new InputStreamReader(SaladDialectProvider.class.getResourceAsStream("/salad-language.json"), "UTF-8");
            DIALECTS = (Map)gson.fromJson((Reader)dialects, Map.class);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

