/*
 * Decompiled with CFR 0.152.
 */
package cucumber.perf.salad;

import cucumber.perf.salad.ISaladDialectProvider;
import cucumber.perf.salad.Parser;
import cucumber.perf.salad.SaladDialect;
import cucumber.perf.salad.SaladDialectProvider;
import cucumber.perf.salad.Token;
import gherkin.GherkinLineSpan;
import gherkin.ast.Location;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenMatcher
implements Parser.ITokenMatcher {
    private static final Pattern LANGUAGE_PATTERN = Pattern.compile("^\\s*#\\s*language\\s*:\\s*([a-zA-Z\\-_]+)\\s*$");
    private final ISaladDialectProvider dialectProvider;
    private SaladDialect currentDialect;
    private String activeDocStringSeparator = null;
    private int indentToRemove = 0;

    public TokenMatcher(ISaladDialectProvider dialectProvider) {
        this.dialectProvider = dialectProvider;
        this.reset();
    }

    public TokenMatcher() {
        this(new SaladDialectProvider());
    }

    public TokenMatcher(String defaultDialectName) {
        this(new SaladDialectProvider(defaultDialectName));
    }

    @Override
    public void reset() {
        this.activeDocStringSeparator = null;
        this.indentToRemove = 0;
        this.currentDialect = this.dialectProvider.getDefaultDialect();
    }

    public SaladDialect getCurrentDialect() {
        return this.currentDialect;
    }

    protected void setTokenMatched(Token token, Parser.TokenType matchedType, String text, String keyword, Integer indent, List<GherkinLineSpan> items) {
        token.matchedType = matchedType;
        token.matchedKeyword = keyword;
        token.matchedText = text;
        token.mathcedItems = items;
        token.matchedSaladDialect = this.getCurrentDialect();
        token.matchedIndent = indent != null ? indent : (token.line == null ? 0 : token.line.indent());
        token.location = new Location(token.location.getLine(), token.matchedIndent + 1);
    }

    @Override
    public boolean match_EOF(Token token) {
        if (token.isEOF()) {
            this.setTokenMatched(token, Parser.TokenType.EOF, null, null, null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_Other(Token token) {
        String text = token.line.getLineText(this.indentToRemove);
        this.setTokenMatched(token, Parser.TokenType.Other, this.unescapeDocString(text), null, 0, null);
        return true;
    }

    @Override
    public boolean match_Empty(Token token) {
        if (token.line.isEmpty()) {
            this.setTokenMatched(token, Parser.TokenType.Empty, null, null, null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_Comment(Token token) {
        if (token.line.startsWith("#")) {
            String text = token.line.getLineText(0);
            this.setTokenMatched(token, Parser.TokenType.Comment, text, null, 0, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_Language(Token token) {
        Matcher matcher = LANGUAGE_PATTERN.matcher(token.line.getLineText(0));
        if (matcher.matches()) {
            String language = matcher.group(1);
            this.setTokenMatched(token, Parser.TokenType.Language, language, null, null, null);
            this.currentDialect = this.dialectProvider.getDialect(language, token.location);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_TagLine(Token token) {
        if (token.line.startsWith("@")) {
            this.setTokenMatched(token, Parser.TokenType.TagLine, null, null, null, token.line.getTags());
            return true;
        }
        return false;
    }

    private boolean matchTitleLine(Token token, Parser.TokenType tokenType, List<String> keywords) {
        for (String keyword : keywords) {
            if (!token.line.startsWithTitleKeyword(keyword)) continue;
            String title = token.line.getRestTrimmed(keyword.length() + ":".length());
            this.setTokenMatched(token, tokenType, title, keyword, null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_DocStringSeparator(Token token) {
        return this.activeDocStringSeparator == null ? this.match_DocStringSeparator(token, "\"\"\"", true) || this.match_DocStringSeparator(token, "```", true) : this.match_DocStringSeparator(token, this.activeDocStringSeparator, false);
    }

    private boolean match_DocStringSeparator(Token token, String separator, boolean isOpen) {
        if (token.line.startsWith(separator)) {
            String contentType = null;
            if (isOpen) {
                contentType = token.line.getRestTrimmed(separator.length());
                this.activeDocStringSeparator = separator;
                this.indentToRemove = token.line.indent();
            } else {
                this.activeDocStringSeparator = null;
                this.indentToRemove = 0;
            }
            this.setTokenMatched(token, Parser.TokenType.DocStringSeparator, contentType, null, null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_TableRow(Token token) {
        if (token.line.startsWith("|")) {
            this.setTokenMatched(token, Parser.TokenType.TableRow, null, null, null, token.line.getTableCells());
            return true;
        }
        return false;
    }

    private String unescapeDocString(String text) {
        return this.activeDocStringSeparator != null ? text.replace("\\\"\\\"\\\"", "\"\"\"") : text;
    }

    @Override
    public boolean match_PlanLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.PlanLine, this.currentDialect.getPlanKeywords());
    }

    @Override
    public boolean match_SimulationLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.SimulationLine, this.currentDialect.getSimulationKeywords());
    }

    @Override
    public boolean match_GroupLine(Token token) {
        List<String> keywords = this.currentDialect.getGroupKeywords();
        for (String keyword : keywords) {
            if (!token.line.startsWith(keyword)) continue;
            String stepText = token.line.getRestTrimmed(keyword.length());
            this.setTokenMatched(token, Parser.TokenType.GroupLine, stepText, keyword, null, null);
            return true;
        }
        return false;
    }

    @Override
    public boolean match_SimulationPeriodLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.SimulationPeriodLine, this.currentDialect.getSimulationPeriodKeywords());
    }

    @Override
    public boolean match_TimeLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.TimeLine, this.currentDialect.getTimeKeywords());
    }

    @Override
    public boolean match_CountLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.CountLine, this.currentDialect.getCountKeywords());
    }

    @Override
    public boolean match_RunnersLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.RunnersLine, this.currentDialect.getRunnersKeywords());
    }

    @Override
    public boolean match_RampUpLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.RampUpLine, this.currentDialect.getRampUpKeywords());
    }

    @Override
    public boolean match_RampDownLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.RampDownLine, this.currentDialect.getRampDownKeywords());
    }

    @Override
    public boolean match_SynchronizedLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.SynchronizedLine, this.currentDialect.getSynchronizedKeywords());
    }

    @Override
    public boolean match_RandomWaitLine(Token token) {
        return this.matchTitleLine(token, Parser.TokenType.RandomWaitLine, this.currentDialect.getRandomWaitKeywords());
    }
}

