/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.api.connection;

import com.mpush.api.connection.Cipher;
import com.mpush.api.router.ClientClassifier;

public final class SessionContext {
    public String osName;
    public String osVersion;
    public String clientVersion;
    public String deviceId;
    public String userId;
    public String tags;
    public int heartbeat = 10000;
    public Cipher cipher;
    private byte clientType;

    public void changeCipher(Cipher cipher) {
        this.cipher = cipher;
    }

    public SessionContext setOsName(String osName) {
        this.osName = osName;
        return this;
    }

    public SessionContext setOsVersion(String osVersion) {
        this.osVersion = osVersion;
        return this;
    }

    public SessionContext setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
        return this;
    }

    public SessionContext setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public SessionContext setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public void setHeartbeat(int heartbeat) {
        this.heartbeat = heartbeat;
    }

    public boolean handshakeOk() {
        return this.deviceId != null && this.deviceId.length() > 0;
    }

    public int getClientType() {
        if (this.clientType == 0) {
            this.clientType = (byte)ClientClassifier.I.getClientType(this.osName);
        }
        return this.clientType;
    }

    public boolean isSecurity() {
        return this.cipher != null;
    }

    public String toString() {
        return "{osName='" + this.osName + '\'' + ", osVersion='" + this.osVersion + '\'' + ", deviceId='" + this.deviceId + '\'' + ", userId='" + this.userId + '\'' + ", tags='" + this.tags + '\'' + ", heartbeat=" + this.heartbeat + '}';
    }
}

