/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.api.protocol;

import com.mpush.api.Constants;
import com.mpush.api.protocol.Command;
import com.mpush.api.protocol.Packet;
import com.mpush.api.spi.common.Json;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.Map;

public final class JsonPacket
extends Packet {
    public Map<String, Object> body;

    public JsonPacket() {
        super(Command.UNKNOWN);
        this.addFlag((byte)16);
    }

    public JsonPacket(Command cmd) {
        super(cmd);
        this.addFlag((byte)16);
    }

    public JsonPacket(Command cmd, int sessionId) {
        super(cmd, sessionId);
        this.addFlag((byte)16);
    }

    public Map<String, Object> getBody() {
        return this.body;
    }

    @Override
    public <T> void setBody(T body) {
        this.body = (Map)body;
    }

    @Override
    public int getBodyLength() {
        return this.body == null ? 0 : this.body.size();
    }

    @Override
    public Packet response(Command command) {
        return new JsonPacket(command, this.sessionId);
    }

    @Override
    public Object toFrame(Channel channel) {
        byte[] json = Json.JSON.toJson(this).getBytes(Constants.UTF_8);
        return new TextWebSocketFrame(Unpooled.wrappedBuffer((byte[])json));
    }

    @Override
    public String toString() {
        return "JsonPacket{cmd=" + this.cmd + ", cc=" + this.cc + ", flags=" + this.flags + ", sessionId=" + this.sessionId + ", lrc=" + this.lrc + ", body=" + this.body + '}';
    }
}

