/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.api.protocol;

import com.mpush.api.protocol.Command;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;

public class Packet {
    public static final int HEADER_LEN = 13;
    public static final byte FLAG_CRYPTO = 1;
    public static final byte FLAG_COMPRESS = 2;
    public static final byte FLAG_BIZ_ACK = 4;
    public static final byte FLAG_AUTO_ACK = 8;
    public static final byte FLAG_JSON_BODY = 16;
    public static final byte HB_PACKET_BYTE = -33;
    public static final byte[] HB_PACKET_BYTES = new byte[]{-33};
    public static final Packet HB_PACKET = new Packet(Command.HEARTBEAT);
    public byte cmd;
    public transient short cc;
    public byte flags;
    public int sessionId;
    public transient byte lrc;
    public transient byte[] body;

    public Packet(byte cmd) {
        this.cmd = cmd;
    }

    public Packet(byte cmd, int sessionId) {
        this.cmd = cmd;
        this.sessionId = sessionId;
    }

    public Packet(Command cmd) {
        this.cmd = cmd.cmd;
    }

    public Packet(Command cmd, int sessionId) {
        this.cmd = cmd.cmd;
        this.sessionId = sessionId;
    }

    public int getBodyLength() {
        return this.body == null ? 0 : this.body.length;
    }

    public void addFlag(byte flag) {
        this.flags = (byte)(this.flags | flag);
    }

    public boolean hasFlag(byte flag) {
        return (this.flags & flag) != 0;
    }

    public <T> T getBody() {
        return (T)this.body;
    }

    public <T> void setBody(T body) {
        this.body = (byte[])body;
    }

    public short calcCheckCode() {
        short checkCode = 0;
        if (this.body != null) {
            for (int i = 0; i < this.body.length; ++i) {
                checkCode = (short)(checkCode + (this.body[i] & 0xFF));
            }
        }
        return checkCode;
    }

    public byte calcLrc() {
        byte[] data = Unpooled.buffer((int)12).writeInt(this.getBodyLength()).writeByte((int)this.cmd).writeShort((int)this.cc).writeByte((int)this.flags).writeInt(this.sessionId).array();
        byte lrc = 0;
        for (int i = 0; i < data.length; ++i) {
            lrc = (byte)(lrc ^ data[i]);
        }
        return lrc;
    }

    public boolean validCheckCode() {
        return this.calcCheckCode() == this.cc;
    }

    public boolean validLrc() {
        return (this.lrc ^ this.calcLrc()) == 0;
    }

    public InetSocketAddress sender() {
        return null;
    }

    public void setRecipient(InetSocketAddress sender) {
    }

    public Packet response(Command command) {
        return new Packet(command, this.sessionId);
    }

    public Object toFrame(Channel channel) {
        return this;
    }

    public static Packet decodePacket(Packet packet, ByteBuf in, int bodyLength) {
        packet.cc = in.readShort();
        packet.flags = in.readByte();
        packet.sessionId = in.readInt();
        packet.lrc = in.readByte();
        if (bodyLength > 0) {
            packet.body = new byte[bodyLength];
            in.readBytes(packet.body);
        }
        return packet;
    }

    public static void encodePacket(Packet packet, ByteBuf out) {
        if (packet.cmd == Command.HEARTBEAT.cmd) {
            out.writeByte(-33);
        } else {
            out.writeInt(packet.getBodyLength());
            out.writeByte((int)packet.cmd);
            out.writeShort((int)packet.cc);
            out.writeByte((int)packet.flags);
            out.writeInt(packet.sessionId);
            out.writeByte((int)packet.lrc);
            if (packet.getBodyLength() > 0) {
                out.writeBytes(packet.body);
            }
        }
        packet.body = null;
    }

    public String toString() {
        return "{cmd=" + this.cmd + ", cc=" + this.cc + ", flags=" + this.flags + ", sessionId=" + this.sessionId + ", lrc=" + this.lrc + ", body=" + (this.body == null ? 0 : this.body.length) + '}';
    }

    public static ByteBuf getHBPacket() {
        return Unpooled.wrappedBuffer((byte[])HB_PACKET_BYTES);
    }
}

