/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.api.protocol;

import com.mpush.api.protocol.Command;
import com.mpush.api.protocol.Packet;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;

public final class UDPPacket
extends Packet {
    private InetSocketAddress address;

    public UDPPacket(byte cmd, InetSocketAddress sender) {
        super(cmd);
        this.address = sender;
    }

    public UDPPacket(Command cmd, int sessionId, InetSocketAddress sender) {
        super(cmd, sessionId);
        this.address = sender;
    }

    public UDPPacket(byte cmd) {
        super(cmd);
    }

    public UDPPacket(Command cmd) {
        super(cmd);
    }

    public UDPPacket(Command cmd, int sessionId) {
        super(cmd, sessionId);
    }

    @Override
    public InetSocketAddress sender() {
        return this.address;
    }

    @Override
    public void setRecipient(InetSocketAddress recipient) {
        this.address = recipient;
    }

    @Override
    public Packet response(Command command) {
        return new UDPPacket(command, this.sessionId, this.address);
    }

    @Override
    public Object toFrame(Channel channel) {
        int capacity = this.cmd == Command.HEARTBEAT.cmd ? 1 : 13 + this.getBodyLength();
        ByteBuf out = channel.alloc().buffer(capacity, capacity);
        UDPPacket.encodePacket(this, out);
        return new DatagramPacket(out, this.sender());
    }
}

