/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.api.push;

import com.mpush.api.Constants;
import com.mpush.api.push.AckModel;
import com.mpush.api.push.PushCallback;
import com.mpush.api.push.PushMsg;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class PushContext {
    private byte[] context;
    private PushMsg pushMsg;
    private String userId;
    private List<String> userIds;
    private AckModel ackModel = AckModel.NO_ACK;
    private PushCallback callback;
    private int timeout = 3000;
    private boolean broadcast = false;
    private Set<String> tags;
    private String condition;
    private String taskId;

    public PushContext(byte[] context) {
        this.context = context;
    }

    public PushContext(PushMsg pushMsg) {
        this.pushMsg = pushMsg;
    }

    public static PushContext build(String msg) {
        return new PushContext(msg.getBytes(Constants.UTF_8));
    }

    public static PushContext build(PushMsg msg) {
        return new PushContext(msg);
    }

    public static String genTaskId() {
        return UUID.randomUUID().toString();
    }

    public byte[] getContext() {
        return this.context;
    }

    public String getUserId() {
        return this.userId;
    }

    public PushContext setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public List<String> getUserIds() {
        return this.userIds;
    }

    public PushContext setUserIds(List<String> userIds) {
        this.userIds = userIds;
        return this;
    }

    public AckModel getAckModel() {
        return this.ackModel;
    }

    public PushContext setAckModel(AckModel ackModel) {
        this.ackModel = ackModel;
        return this;
    }

    public PushCallback getCallback() {
        return this.callback;
    }

    public PushContext setCallback(PushCallback callback) {
        this.callback = callback;
        return this;
    }

    public PushMsg getPushMsg() {
        return this.pushMsg;
    }

    public boolean isBroadcast() {
        return this.broadcast;
    }

    public PushContext setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public PushContext setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public PushContext setTags(Set<String> tags) {
        this.tags = tags;
        return this;
    }

    public String getCondition() {
        return this.condition;
    }

    public PushContext setCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public PushContext setTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }
}

