/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.api.router;

import com.mpush.api.connection.Connection;
import com.mpush.api.connection.SessionContext;
import com.mpush.api.router.ClientClassifier;

public final class ClientLocation {
    private String host;
    private int port;
    private String osName;
    private String clientVersion;
    private String deviceId;
    private String connId;
    private transient int clientType;

    public String getHost() {
        return this.host;
    }

    public ClientLocation setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public ClientLocation setPort(int port) {
        this.port = port;
        return this;
    }

    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getConnId() {
        return this.connId;
    }

    public void setConnId(String connId) {
        this.connId = connId;
    }

    public int getClientType() {
        if (this.clientType == 0) {
            this.clientType = ClientClassifier.I.getClientType(this.osName);
        }
        return this.clientType;
    }

    public boolean isOnline() {
        return this.connId != null;
    }

    public boolean isOffline() {
        return this.connId == null;
    }

    public ClientLocation offline() {
        this.connId = null;
        return this;
    }

    public boolean isThisPC(String host, int port) {
        return this.port == port && this.host.equals(host);
    }

    public String getHostAndPort() {
        return this.host + ":" + this.port;
    }

    public static ClientLocation from(Connection connection) {
        SessionContext context = connection.getSessionContext();
        ClientLocation location = new ClientLocation();
        location.osName = context.osName;
        location.clientVersion = context.clientVersion;
        location.deviceId = context.deviceId;
        location.connId = connection.getId();
        return location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientLocation location = (ClientLocation)o;
        return this.clientType == location.clientType;
    }

    public int hashCode() {
        return Integer.hashCode(this.clientType);
    }

    public String toString() {
        return "ClientLocation{host='" + this.host + ":" + this.port + "', osName='" + this.osName + '\'' + ", clientVersion='" + this.clientVersion + '\'' + ", deviceId='" + this.deviceId + '\'' + ", connId='" + this.connId + '\'' + '}';
    }
}

