/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.api.service;

import com.mpush.api.service.FutureListener;
import com.mpush.api.service.Listener;
import com.mpush.api.service.Service;
import com.mpush.api.service.ServiceException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class BaseService
implements Service {
    protected final AtomicBoolean started = new AtomicBoolean();

    @Override
    public void init() {
    }

    @Override
    public boolean isRunning() {
        return this.started.get();
    }

    protected void tryStart(Listener l, FunctionEx function) {
        FutureListener listener = this.wrap(l);
        if (this.started.compareAndSet(false, true)) {
            try {
                this.init();
                function.apply(listener);
                listener.monitor(this);
            }
            catch (Throwable e) {
                listener.onFailure(e);
                throw new ServiceException(e);
            }
        } else {
            listener.onFailure(new ServiceException("service already started."));
        }
    }

    protected void tryStop(Listener l, FunctionEx function) {
        FutureListener listener = this.wrap(l);
        if (this.started.compareAndSet(true, false)) {
            try {
                function.apply(listener);
                listener.monitor(this);
            }
            catch (Throwable e) {
                listener.onFailure(e);
                throw new ServiceException(e);
            }
        } else {
            listener.onFailure(new ServiceException("service already stopped."));
        }
    }

    @Override
    public final CompletableFuture<Boolean> start() {
        FutureListener listener = new FutureListener(this.started);
        this.start(listener);
        return listener;
    }

    @Override
    public final CompletableFuture<Boolean> stop() {
        FutureListener listener = new FutureListener(this.started);
        this.stop(listener);
        return listener;
    }

    @Override
    public final boolean syncStart() {
        return this.start().join();
    }

    @Override
    public final boolean syncStop() {
        return this.stop().join();
    }

    @Override
    public void start(Listener listener) {
        this.tryStart(listener, this::doStart);
    }

    @Override
    public void stop(Listener listener) {
        this.tryStop(listener, this::doStop);
    }

    protected void doStart(Listener listener) throws Throwable {
        listener.onSuccess(new Object[0]);
    }

    protected void doStop(Listener listener) throws Throwable {
        listener.onSuccess(new Object[0]);
    }

    public FutureListener wrap(Listener l) {
        if (l == null) {
            return new FutureListener(this.started);
        }
        if (l instanceof FutureListener) {
            return (FutureListener)l;
        }
        return new FutureListener(l, this.started);
    }

    protected static interface FunctionEx {
        public void apply(Listener var1) throws Throwable;
    }
}

