/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.api.service;

import com.mpush.api.service.BaseService;
import com.mpush.api.service.Listener;
import com.mpush.api.service.ServiceException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class FutureListener
extends CompletableFuture<Boolean>
implements Listener {
    private final Listener l;
    private final AtomicBoolean started;

    public FutureListener(AtomicBoolean started) {
        this.started = started;
        this.l = null;
    }

    public FutureListener(Listener l, AtomicBoolean started) {
        this.l = l;
        this.started = started;
    }

    @Override
    public void onSuccess(Object ... args) {
        if (this.isDone()) {
            return;
        }
        this.complete(this.started.get());
        if (this.l != null) {
            this.l.onSuccess(args);
        }
    }

    @Override
    public void onFailure(Throwable cause) {
        if (this.isDone()) {
            return;
        }
        this.completeExceptionally(cause);
        if (this.l != null) {
            this.l.onFailure(cause);
        }
        throw cause instanceof ServiceException ? (ServiceException)cause : new ServiceException(cause);
    }

    public void monitor(BaseService service) {
        if (this.isDone()) {
            return;
        }
        FutureListener.runAsync(() -> {
            try {
                this.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                this.onFailure(new ServiceException(String.format("service %s monitor timeout", service.getClass().getSimpleName())));
            }
        });
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException();
    }
}

