/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.api.spi.net;

import java.net.URL;
import java.util.Objects;

public class DnsMapping {
    protected String ip;
    protected int port;

    public DnsMapping() {
    }

    public DnsMapping(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public DnsMapping setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public DnsMapping setPort(int port) {
        this.port = port;
        return this;
    }

    public static DnsMapping parse(String addr) {
        String[] host_port = Objects.requireNonNull(addr, "dns mapping can not be null").split(":");
        if (host_port.length == 1) {
            return new DnsMapping(host_port[0], 80);
        }
        return new DnsMapping(host_port[0], Integer.valueOf(host_port[1]));
    }

    public String translate(URL uri) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(uri.getProtocol()).append("://").append(this.ip).append(':').append(this.port).append(uri.getPath());
        String query = uri.getQuery();
        if (query != null) {
            sb.append('?').append(query);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsMapping that = (DnsMapping)o;
        if (this.port != that.port) {
            return false;
        }
        return this.ip.equals(that.ip);
    }

    public int hashCode() {
        int result = this.ip.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return this.ip + ":" + this.port;
    }
}

