/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.api.srd;

import com.mpush.api.srd.ServiceNode;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class CommonServiceNode
implements ServiceNode {
    private String host;
    private int port;
    private Map<String, String> attrs;
    private transient String name;
    private transient String nodeId;
    private transient boolean persistent;

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setServiceName(String name) {
        this.name = name;
    }

    public CommonServiceNode addAttr(String name, String value) {
        if (this.attrs == null) {
            this.attrs = new HashMap<String, String>();
        }
        this.attrs.put(name, value);
        return this;
    }

    @Override
    public String getAttr(String name) {
        if (this.attrs == null || this.attrs.isEmpty()) {
            return null;
        }
        return this.attrs.get(name);
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public String hostAndPort() {
        return this.host + ":" + this.port;
    }

    @Override
    public String serviceName() {
        return this.name;
    }

    @Override
    public String nodeId() {
        if (this.nodeId == null) {
            this.nodeId = UUID.randomUUID().toString();
        }
        return this.nodeId;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public Map<String, String> getAttrs() {
        return this.attrs;
    }

    public void setAttrs(Map<String, String> attrs) {
        this.attrs = attrs;
    }

    public String toString() {
        return "{host='" + this.host + '\'' + ", port=" + this.port + ", attrs=" + this.attrs + ", persistent=" + this.persistent + '}';
    }
}

