/*
 * Decompiled with CFR 0.152.
 */
package io.mstream.trader.commons.http.client;

import io.mstream.trader.commons.config.model.DownstreamService;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.protocol.http.client.HttpClient;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.net.ssl.SSLEngine;

public abstract class HttpClientSupplier
implements Supplier<HttpClient<ByteBuf, ByteBuf>> {
    private final Supplier<DownstreamService> configSupplier;
    private final Supplier<SSLEngine> sslEngineSupplier;
    private final int timeoutInSeconds;

    @Inject
    public HttpClientSupplier(Supplier<DownstreamService> configSupplier, Supplier<SSLEngine> sslEngineSupplier, int timeoutInSeconds) {
        this.configSupplier = configSupplier;
        this.sslEngineSupplier = sslEngineSupplier;
        this.timeoutInSeconds = timeoutInSeconds;
    }

    @Override
    public HttpClient<ByteBuf, ByteBuf> get() {
        DownstreamService dateFeed = this.configSupplier.get();
        URI uri = URI.create(dateFeed.getUrl().url());
        String host = uri.getHost();
        int port = uri.getPort();
        InetSocketAddress serviceAddress = new InetSocketAddress(host, port);
        HttpClient httpClient = HttpClient.newClient((SocketAddress)serviceAddress).readTimeOut(this.timeoutInSeconds, TimeUnit.SECONDS);
        if ("https".equals(uri.getScheme())) {
            httpClient.secure(this.sslEngineSupplier.get());
        }
        return httpClient;
    }
}

