package io.mstream.trader.commons.validation;

import com.google.inject.AbstractModule;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.FactoryModuleBuilder;


public class ValidationModule extends AbstractModule {

    @Override
    protected void configure() {

        install(new FactoryModuleBuilder()
                .implement(ValidationResult.class, ValidationResult.class)
                .build(ValidationResultFactory.class));

        bind(ValidationErrorFactory.class)
                .to(ValidationErrorFactoryImpl.class)
                .in(Singleton.class);
    }
}
