package io.mstream.trader.commons.validation;


import com.google.inject.assistedinject.Assisted;

import javax.inject.Inject;
import java.util.HashSet;
import java.util.Set;

import static java.util.Collections.unmodifiableSet;


public class ValidationResult {

    private final Set<ValidationError> validationErrors;

    @Inject
    public ValidationResult(@Assisted Set<ValidationError> validationErrors) {
        this.validationErrors = unmodifiableSet(new HashSet<>(validationErrors));
    }

    public boolean isValid() {
        return validationErrors.isEmpty();
    }

    public Set<ValidationError> getValidationErrors() {
        return validationErrors;
    }

    public ValidationResult combine(ValidationResult validationResult) {
        Set<ValidationError> combinedValidationErrors = new HashSet<>();
        combinedValidationErrors.addAll(validationErrors);
        combinedValidationErrors.addAll(validationResult.validationErrors);
        return new ValidationResult(combinedValidationErrors);
    }
}
