package io.mstream.trader.commons.validation.parameter;

import io.mstream.trader.commons.http.parameter.Parameter;
import io.mstream.trader.commons.validation.*;
import rx.Observable;

import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Set;


public class LocalDateValidator extends AbstractParameterValidator {

    private final DateTimeFormatter dateTimeFormatter;

    public LocalDateValidator(
            ValidationResultFactory validationResultFactory,
            ValidationErrorFactory validationErrorFactory,
            DateTimeFormatter dateTimeFormatter) {

        super(validationResultFactory, validationErrorFactory);

        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public ValidationResult validate(Parameter dateParam) {
        String paramName = dateParam.getName();
        String paramValue = dateParam.getValue();
        Set<ValidationError> validationErrors = new HashSet<>();
        try {
            dateTimeFormatter.parse(paramValue);
        } catch (Exception e) {
            validationErrors.add(
                    validationErrorFactory.create(
                            ValidationErrorDescription.WRONG_FORMAT,
                            paramName
                    )
            );
        }
        return validationResultFactory.create(validationErrors);
    }
}
