package io.mstream.trader.commons.validation.parameter;

import io.mstream.trader.commons.validation.ValidationErrorFactory;
import io.mstream.trader.commons.validation.ValidationResultFactory;

import javax.inject.Inject;
import java.time.format.DateTimeFormatter;


public class LocalDateValidatorFactory {

    private final ValidationResultFactory validationResultFactory;
    private final ValidationErrorFactory validationErrorFactory;

    @Inject
    public LocalDateValidatorFactory(
            ValidationResultFactory validationResultFactory,
            ValidationErrorFactory validationErrorFactory) {
        this.validationResultFactory = validationResultFactory;
        this.validationErrorFactory = validationErrorFactory;
    }

    public LocalDateValidator create(DateTimeFormatter dateTimeFormatter) {
        return new LocalDateValidator(
                validationResultFactory,
                validationErrorFactory,
                dateTimeFormatter);
    }

}
