package io.mstream.trader.commons.validation.parameter;


import io.mstream.trader.commons.http.parameter.Parameter;
import io.mstream.trader.commons.utils.Preconditions;
import io.mstream.trader.commons.validation.*;
import rx.Observable;

import javax.inject.Inject;
import java.util.HashSet;
import java.util.Set;

import static io.mstream.trader.commons.utils.StringUtil.isNullOrEmpty;


public class RequiredParameterValidator
        extends AbstractParameterValidator {

    @Inject
    public RequiredParameterValidator(
            ValidationResultFactory validationResultFactory,
            ValidationErrorFactory validationErrorFactory
    ) {
        super(validationResultFactory, validationErrorFactory);
    }

    @Override
    public ValidationResult validate(Parameter parameter) {
        Preconditions.checkNotNull("parameter", parameter);
        String parameterName = parameter.getName();
        String parameterValue = parameter.getValue();
        Set<ValidationError> validationErrors = new HashSet<>();
        if (isNullOrEmpty(parameterValue)) {
            validationErrors.add(
                    validationErrorFactory.create(
                            ValidationErrorDescription.NOT_PROVIDED,
                            parameterName
                    )
            );
        }
        return validationResultFactory.create(validationErrors);
    }
}
