package io.mstream.trader.commons.validation.parameter;

import io.mstream.trader.commons.http.parameter.Parameter;
import io.mstream.trader.commons.validation.*;
import rx.Observable;

import javax.inject.Inject;
import java.util.HashSet;
import java.util.Set;


public class TimestampValidator
        extends AbstractParameterValidator {

    @Inject
    public TimestampValidator(
            ValidationResultFactory validationResultFactory,
            ValidationErrorFactory validationErrorFactory) {

        super(validationResultFactory, validationErrorFactory);
    }

    @Override
    public ValidationResult validate(Parameter timestampParam) {
        String paramName = timestampParam.getName();
        String paramValue = timestampParam.getValue();
        Set<ValidationError> validationErrors = new HashSet<>();
        try {
            long timestamp = Long.parseLong(paramValue);
            if (timestamp < 0) {
                validationErrors.add(
                        validationErrorFactory.create(
                                ValidationErrorDescription.NEGATIVE_NUMBER,
                                paramName
                        )
                );
            }
        } catch (Exception e) {
            validationErrors.add(
                    validationErrorFactory.create(
                            ValidationErrorDescription.WRONG_FORMAT,
                            paramName
                    )
            );
        }
        return validationResultFactory.create(validationErrors);
    }
}
