/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet.html;

import ec.util.spreadsheet.Book;
import ec.util.spreadsheet.helpers.FileHelper;
import ec.util.spreadsheet.html.HtmlBookReader;
import ec.util.spreadsheet.html.HtmlBookWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import org.checkerframework.checker.nullness.qual.NonNull;

public class HtmlBookFactory
extends Book.Factory {
    private static final String HTML_TYPE = "text/html";
    private final XMLOutputFactory xof = XMLOutputFactory.newInstance();

    public String getName() {
        return "Basic Html";
    }

    public int getRank() {
        return 127;
    }

    public boolean canLoad() {
        return true;
    }

    public Book load(File file) throws IOException {
        return this.newReader().read(file);
    }

    public Book load(InputStream stream) throws IOException {
        return this.newReader().read(stream);
    }

    public @NonNull Map<String, List<String>> getExtensionsByMediaType() {
        return Collections.singletonMap(HTML_TYPE, Arrays.asList(".html", ".htm"));
    }

    public boolean accept(File pathname) {
        return FileHelper.hasExtension((File)pathname, (String[])new String[]{".html", ".htm"});
    }

    public void store(OutputStream stream, Book book) throws IOException {
        this.newWriter().write(book, stream);
    }

    public boolean isSupportedDataType(Class<?> type) {
        return String.class.isAssignableFrom(type);
    }

    private HtmlBookReader newReader() {
        return new HtmlBookReader();
    }

    private HtmlBookWriter newWriter() {
        return new HtmlBookWriter(this.xof);
    }
}

