/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet.od;

import ec.util.spreadsheet.Cell;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class OdCell
extends Cell {
    private final ZoneId zoneId = ZoneId.systemDefault();
    private transient Object value = null;

    OdCell() {
    }

    private boolean isValid(Object value) {
        return value instanceof LocalDateTime || value instanceof Number || value instanceof String;
    }

    @Nullable OdCell withValue(@NonNull Object value) {
        this.value = value;
        return this.isValid(value) ? this : null;
    }

    public boolean isDate() {
        return this.value instanceof LocalDateTime;
    }

    public boolean isNumber() {
        return this.value instanceof Number;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    public Date getDate() {
        try {
            return Date.from(((LocalDateTime)this.value).atZone(this.zoneId).toInstant());
        }
        catch (ClassCastException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    public Number getNumber() {
        try {
            return (Number)this.value;
        }
        catch (ClassCastException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    public String getString() {
        try {
            return (String)this.value;
        }
        catch (ClassCastException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    public String toString() {
        return this.value != null ? this.value.toString() : "Null";
    }
}

