/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet.od;

import com.github.miachm.sods.Range;
import ec.util.spreadsheet.Cell;
import ec.util.spreadsheet.Sheet;
import ec.util.spreadsheet.od.OdCell;

final class OdSheet
extends Sheet {
    private static final int BUGGED_COLUMN_COUNT = 16384;
    private final String name;
    private final Range sheet;
    private final int columnCount;
    private final OdCell flyweightCell;

    public OdSheet(com.github.miachm.sods.Sheet sheet) {
        this.name = sheet.getName();
        this.sheet = sheet.getDataRange();
        this.columnCount = OdSheet.computeColumnCount(this.sheet);
        this.flyweightCell = new OdCell();
    }

    static int computeColumnCount(Range sheet) {
        if (sheet.getNumRows() == 0) {
            return 0;
        }
        int result = sheet.getNumColumns();
        if (result != 16384) {
            return result;
        }
        int min = 0;
        int max = 16384;
        do {
            if (!OdSheet.isNullOrEmpty(sheet, 0, result = (min + max) / 2)) {
                min = result + 1;
                continue;
            }
            max = result - 1;
        } while (min <= max);
        return result + 1;
    }

    static boolean isNullOrEmpty(Range sheet, int rowIdx, int columnIdx) throws IndexOutOfBoundsException {
        return sheet.getCell(rowIdx, columnIdx).getValue() == null;
    }

    public int getRowCount() {
        return this.sheet.getNumRows();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public Cell getCell(int rowIdx, int columnIdx) {
        Object value = this.sheet.getCell(rowIdx, columnIdx).getValue();
        return value != null ? this.flyweightCell.withValue(value) : null;
    }

    public String getName() {
        return this.name.replace("_", " ");
    }
}

