/*
 * Decompiled with CFR 0.152.
 */
package com.github.nfwork.dbfound.starter.exception;

import com.nfwork.dbfound.dto.ResponseObject;
import com.nfwork.dbfound.exception.CollisionException;
import com.nfwork.dbfound.exception.DBFoundPackageException;
import com.nfwork.dbfound.exception.DBFoundRuntimeException;
import com.nfwork.dbfound.exception.FileDownLoadInterrupt;
import com.nfwork.dbfound.util.LogUtil;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;

@Component
public class DBFoundExceptionhandle {
    public ResponseObject handle(Exception exception, HttpServletRequest request, HttpServletResponse response) {
        ResponseObject ro = new ResponseObject();
        try {
            if (exception instanceof CollisionException) {
                response.setStatus(403);
            } else {
                response.setStatus(500);
            }
            ro.setSuccess(false);
            exception = DBFoundExceptionhandle.getException(exception);
            ro.setMessage(exception.getMessage());
            if (exception instanceof SocketException || exception.getCause() instanceof SocketException) {
                LogUtil.warn((String)("client socket exception:" + exception.getMessage()));
                return ro;
            }
            if (exception instanceof FileDownLoadInterrupt) {
                LogUtil.warn((String)exception.getMessage());
                return null;
            }
            String em = exception.getMessage();
            if (exception instanceof DBFoundRuntimeException) {
                LogUtil.info((String)(exception.getClass().getName() + ":" + em));
            } else {
                em = exception.getClass().getName() + ":" + em;
                LogUtil.error((String)em, (Throwable)exception);
            }
            ro.setMessage(em);
        }
        catch (Exception e) {
            LogUtil.error((String)e.getMessage(), (Throwable)e);
        }
        return ro;
    }

    private static Exception getException(Exception exception) {
        Throwable throwable;
        if (exception instanceof DBFoundPackageException) {
            DBFoundPackageException pkgException = (DBFoundPackageException)exception;
            if (pkgException.getMessage() != null) {
                return pkgException;
            }
            Throwable throwable2 = exception.getCause();
            if (throwable2 != null && throwable2 instanceof Exception) {
                return (Exception)throwable2;
            }
        } else if (exception instanceof InvocationTargetException && (throwable = exception.getCause()) != null && throwable instanceof Exception) {
            return (Exception)throwable;
        }
        return exception;
    }
}

